/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.xslt;

import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.annotations.Recorder;
import java.util.Map;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import org.apache.camel.CamelContext;
import org.apache.camel.component.xslt.DefaultXsltUriResolverFactory;
import org.apache.camel.component.xslt.TransformerFactoryConfigurationStrategy;
import org.apache.camel.component.xslt.XsltComponent;
import org.apache.camel.component.xslt.XsltEndpoint;
import org.apache.camel.component.xslt.XsltUriResolverFactory;
import org.apache.camel.quarkus.component.xslt.CamelXsltConfig;
import org.apache.camel.quarkus.component.xslt.CamelXsltErrorListener;
import org.apache.camel.quarkus.component.xslt.RuntimeUriResolver;
import org.apache.camel.quarkus.support.xalan.XalanTransformerFactory;

@Recorder
public class CamelXsltRecorder {
    public RuntimeValue<XsltComponent> createXsltComponent(CamelXsltConfig config, RuntimeValue<RuntimeUriResolver.Builder> uriResolverBuilder) {
        RuntimeUriResolver uriResolver = ((RuntimeUriResolver.Builder)uriResolverBuilder.getValue()).build();
        QuarkusTransformerFactoryConfigurationStrategy strategy = new QuarkusTransformerFactoryConfigurationStrategy(config.packageName(), config.features(), uriResolver);
        XsltComponent component = new XsltComponent();
        component.setUriResolverFactory((XsltUriResolverFactory)new QuarkusXsltUriResolverFactory(uriResolver));
        component.setTransformerFactoryConfigurationStrategy((TransformerFactoryConfigurationStrategy)strategy);
        component.setTransformerFactoryClass(XalanTransformerFactory.class.getName());
        return new RuntimeValue((Object)component);
    }

    public RuntimeValue<RuntimeUriResolver.Builder> createRuntimeUriResolverBuilder() {
        return new RuntimeValue((Object)new RuntimeUriResolver.Builder());
    }

    public void addRuntimeUriResolverEntry(RuntimeValue<RuntimeUriResolver.Builder> builder, String templateUri, String transletClassName) {
        ((RuntimeUriResolver.Builder)builder.getValue()).entry(templateUri, transletClassName);
    }

    static class QuarkusTransformerFactoryConfigurationStrategy
    implements TransformerFactoryConfigurationStrategy {
        private final String packageName;
        private final RuntimeUriResolver uriResolver;
        private final Map<String, Boolean> features;

        public QuarkusTransformerFactoryConfigurationStrategy(String packageName, Map<String, Boolean> features, RuntimeUriResolver uriResolver) {
            this.uriResolver = uriResolver;
            this.packageName = packageName;
            this.features = features;
        }

        public void configure(TransformerFactory tf, XsltEndpoint endpoint) {
            String className = this.uriResolver.getTransletClassName(endpoint.getResourceUri());
            if (className != null) {
                for (Map.Entry<String, Boolean> entry : this.features.entrySet()) {
                    try {
                        tf.setFeature(entry.getKey(), entry.getValue());
                    }
                    catch (TransformerException e) {
                        throw new RuntimeException("Could not set TransformerFactory feature '" + entry.getKey() + "' = " + String.valueOf(entry.getValue()), e);
                    }
                }
                tf.setAttribute("use-classpath", true);
                tf.setAttribute("translet-name", className);
                tf.setAttribute("package-name", this.packageName);
                tf.setErrorListener(new CamelXsltErrorListener());
                endpoint.setTransformerFactory(tf);
            }
        }
    }

    static class QuarkusXsltUriResolverFactory
    extends DefaultXsltUriResolverFactory {
        private final RuntimeUriResolver uriResolver;

        public QuarkusXsltUriResolverFactory(RuntimeUriResolver uriResolver) {
            this.uriResolver = uriResolver;
        }

        public URIResolver createUriResolver(CamelContext camelContext, String resourceUri) {
            if (this.uriResolver.getTransletClassName(resourceUri) != null) {
                return this.uriResolver;
            }
            return super.createUriResolver(camelContext, resourceUri);
        }
    }
}

