/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.aws.sns.springboot;

import javax.annotation.Generated;
import com.amazonaws.Protocol;
import com.amazonaws.services.sns.AmazonSNS;
import com.amazonaws.services.sqs.AmazonSQS;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * The aws-sns component is used for sending messages to an Amazon Simple
 * Notification Topic.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.springboot.maven.SpringBootAutoConfigurationMojo")
@ConfigurationProperties(prefix = "camel.component.aws-sns")
public class SnsComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the aws-sns component. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * Amazon AWS Access Key
     */
    private String accessKey;
    /**
     * Whether the producer should be started lazy (on the first message). By
     * starting lazy you can use this to allow CamelContext and routes to
     * startup in situations where a producer may otherwise fail during starting
     * and cause the route to fail being started. By deferring this startup to
     * be lazy then the startup failure can be handled during routing messages
     * via Camel's routing error handlers. Beware that when the first message is
     * processed then creating and starting the producer may take a little time
     * and prolong the total processing time of the processing.
     */
    private Boolean lazyStartProducer = false;
    /**
     * The region in which SNS client needs to work
     */
    private String region;
    /**
     * Amazon AWS Secret Key
     */
    private String secretKey;
    /**
     * Whether the component should use basic property binding (Camel 2.x) or
     * the newer property binding with additional capabilities
     */
    private Boolean basicPropertyBinding = false;
    /**
     * The AWS SNS default configuration
     */
    private SnsConfigurationNestedConfiguration configuration;

    public String getAccessKey() {
        return accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public Boolean getLazyStartProducer() {
        return lazyStartProducer;
    }

    public void setLazyStartProducer(Boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public Boolean getBasicPropertyBinding() {
        return basicPropertyBinding;
    }

    public void setBasicPropertyBinding(Boolean basicPropertyBinding) {
        this.basicPropertyBinding = basicPropertyBinding;
    }

    public SnsConfigurationNestedConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(
            SnsConfigurationNestedConfiguration configuration) {
        this.configuration = configuration;
    }

    public static class SnsConfigurationNestedConfiguration {
        public static final Class CAMEL_NESTED_CLASS = org.apache.camel.component.aws.sns.SnsConfiguration.class;
        /**
         * Amazon AWS Access Key
         */
        private String accessKey;
        /**
         * To use the AmazonSNS as the client
         */
        private AmazonSNS amazonSNSClient;
        /**
         * An SQS Client to use as bridge between SNS and SQS
         */
        private AmazonSQS amazonSQSClient;
        /**
         * Setting the autocreation of the topic
         */
        private Boolean autoCreateTopic = true;
        /**
         * The ID of an AWS-managed customer master key (CMK) for Amazon SNS or
         * a custom CMK.
         */
        private String kmsMasterKeyId;
        /**
         * The message structure to use such as json
         */
        private String messageStructure;
        /**
         * The policy for this queue
         */
        private String policy;
        /**
         * To define a proxy host when instantiating the SNS client
         */
        private String proxyHost;
        /**
         * To define a proxy port when instantiating the SNS client
         */
        private Integer proxyPort;
        /**
         * To define a proxy protocol when instantiating the SNS client
         */
        private Protocol proxyProtocol = Protocol.HTTPS;
        /**
         * The queueUrl to subscribe to
         */
        private String queueUrl;
        /**
         * The region in which SNS client needs to work. When using this
         * parameter, the configuration will expect the capitalized name of the
         * region (for example AP_EAST_1) You'll need to use the name
         * Regions.EU_WEST_1.name()
         */
        private String region;
        /**
         * Amazon AWS Secret Key
         */
        private String secretKey;
        /**
         * Define if Server Side Encryption is enabled or not on the topic
         */
        private Boolean serverSideEncryptionEnabled = false;
        /**
         * The subject which is used if the message header 'CamelAwsSnsSubject'
         * is not present.
         */
        private String subject;
        /**
         * Define if the subscription between SNS Topic and SQS must be done or
         * not
         */
        private Boolean subscribeSNStoSQS = false;
        private String topicArn;
        private String topicName;

        public String getAccessKey() {
            return accessKey;
        }

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public AmazonSNS getAmazonSNSClient() {
            return amazonSNSClient;
        }

        public void setAmazonSNSClient(AmazonSNS amazonSNSClient) {
            this.amazonSNSClient = amazonSNSClient;
        }

        public AmazonSQS getAmazonSQSClient() {
            return amazonSQSClient;
        }

        public void setAmazonSQSClient(AmazonSQS amazonSQSClient) {
            this.amazonSQSClient = amazonSQSClient;
        }

        public Boolean getAutoCreateTopic() {
            return autoCreateTopic;
        }

        public void setAutoCreateTopic(Boolean autoCreateTopic) {
            this.autoCreateTopic = autoCreateTopic;
        }

        public String getKmsMasterKeyId() {
            return kmsMasterKeyId;
        }

        public void setKmsMasterKeyId(String kmsMasterKeyId) {
            this.kmsMasterKeyId = kmsMasterKeyId;
        }

        public String getMessageStructure() {
            return messageStructure;
        }

        public void setMessageStructure(String messageStructure) {
            this.messageStructure = messageStructure;
        }

        public String getPolicy() {
            return policy;
        }

        public void setPolicy(String policy) {
            this.policy = policy;
        }

        public String getProxyHost() {
            return proxyHost;
        }

        public void setProxyHost(String proxyHost) {
            this.proxyHost = proxyHost;
        }

        public Integer getProxyPort() {
            return proxyPort;
        }

        public void setProxyPort(Integer proxyPort) {
            this.proxyPort = proxyPort;
        }

        public Protocol getProxyProtocol() {
            return proxyProtocol;
        }

        public void setProxyProtocol(Protocol proxyProtocol) {
            this.proxyProtocol = proxyProtocol;
        }

        public String getQueueUrl() {
            return queueUrl;
        }

        public void setQueueUrl(String queueUrl) {
            this.queueUrl = queueUrl;
        }

        public String getRegion() {
            return region;
        }

        public void setRegion(String region) {
            this.region = region;
        }

        public String getSecretKey() {
            return secretKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public Boolean getServerSideEncryptionEnabled() {
            return serverSideEncryptionEnabled;
        }

        public void setServerSideEncryptionEnabled(
                Boolean serverSideEncryptionEnabled) {
            this.serverSideEncryptionEnabled = serverSideEncryptionEnabled;
        }

        public String getSubject() {
            return subject;
        }

        public void setSubject(String subject) {
            this.subject = subject;
        }

        public Boolean getSubscribeSNStoSQS() {
            return subscribeSNStoSQS;
        }

        public void setSubscribeSNStoSQS(Boolean subscribeSNStoSQS) {
            this.subscribeSNStoSQS = subscribeSNStoSQS;
        }

        public String getTopicArn() {
            return topicArn;
        }

        public void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public String getTopicName() {
            return topicName;
        }

        public void setTopicName(String topicName) {
            this.topicName = topicName;
        }
    }
}