/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.aws.sns.springboot;

import javax.annotation.Generated;
import com.amazonaws.Protocol;
import org.apache.camel.component.aws.sns.SnsComponent;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Send messages to an AWS Simple Notification Topic.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.springboot.maven.SpringBootAutoConfigurationMojo")
@ConfigurationProperties(prefix = "camel.component.aws-sns")
public class SnsComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the aws-sns component. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * To use the AmazonSNS as the client. The option is a
     * com.amazonaws.services.sns.AmazonSNS type.
     */
    private String amazonSNSClient;
    /**
     * An SQS Client to use as bridge between SNS and SQS. The option is a
     * com.amazonaws.services.sqs.AmazonSQS type.
     */
    private String amazonSQSClient;
    /**
     * Setting the autocreation of the topic
     */
    private Boolean autoCreateTopic = true;
    /**
     * The component configuration. The option is a
     * org.apache.camel.component.aws.sns.SnsConfiguration type.
     */
    private String configuration;
    /**
     * The ID of an AWS-managed customer master key (CMK) for Amazon SNS or a
     * custom CMK.
     */
    private String kmsMasterKeyId;
    /**
     * Whether the producer should be started lazy (on the first message). By
     * starting lazy you can use this to allow CamelContext and routes to
     * startup in situations where a producer may otherwise fail during starting
     * and cause the route to fail being started. By deferring this startup to
     * be lazy then the startup failure can be handled during routing messages
     * via Camel's routing error handlers. Beware that when the first message is
     * processed then creating and starting the producer may take a little time
     * and prolong the total processing time of the processing.
     */
    private Boolean lazyStartProducer = false;
    /**
     * The message structure to use such as json
     */
    private String messageStructure;
    /**
     * The policy for this queue
     */
    private String policy;
    /**
     * To define a proxy host when instantiating the SNS client
     */
    private String proxyHost;
    /**
     * To define a proxy port when instantiating the SNS client
     */
    private Integer proxyPort;
    /**
     * To define a proxy protocol when instantiating the SNS client
     */
    private Protocol proxyProtocol = Protocol.HTTPS;
    /**
     * The queueUrl to subscribe to
     */
    private String queueUrl;
    /**
     * The region in which SNS client needs to work. When using this parameter,
     * the configuration will expect the capitalized name of the region (for
     * example AP_EAST_1) You'll need to use the name Regions.EU_WEST_1.name()
     */
    private String region;
    /**
     * Define if Server Side Encryption is enabled or not on the topic
     */
    private Boolean serverSideEncryptionEnabled = false;
    /**
     * The subject which is used if the message header 'CamelAwsSnsSubject' is
     * not present.
     */
    private String subject;
    /**
     * Define if the subscription between SNS Topic and SQS must be done or not
     */
    private Boolean subscribeSNStoSQS = false;
    /**
     * Whether the component should use basic property binding (Camel 2.x) or
     * the newer property binding with additional capabilities
     */
    private Boolean basicPropertyBinding = false;
    /**
     * Amazon AWS Access Key
     */
    private String accessKey;
    /**
     * Amazon AWS Secret Key
     */
    private String secretKey;

    public String getAmazonSNSClient() {
        return amazonSNSClient;
    }

    public void setAmazonSNSClient(String amazonSNSClient) {
        this.amazonSNSClient = amazonSNSClient;
    }

    public String getAmazonSQSClient() {
        return amazonSQSClient;
    }

    public void setAmazonSQSClient(String amazonSQSClient) {
        this.amazonSQSClient = amazonSQSClient;
    }

    public Boolean getAutoCreateTopic() {
        return autoCreateTopic;
    }

    public void setAutoCreateTopic(Boolean autoCreateTopic) {
        this.autoCreateTopic = autoCreateTopic;
    }

    public String getConfiguration() {
        return configuration;
    }

    public void setConfiguration(String configuration) {
        this.configuration = configuration;
    }

    public String getKmsMasterKeyId() {
        return kmsMasterKeyId;
    }

    public void setKmsMasterKeyId(String kmsMasterKeyId) {
        this.kmsMasterKeyId = kmsMasterKeyId;
    }

    public Boolean getLazyStartProducer() {
        return lazyStartProducer;
    }

    public void setLazyStartProducer(Boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public String getMessageStructure() {
        return messageStructure;
    }

    public void setMessageStructure(String messageStructure) {
        this.messageStructure = messageStructure;
    }

    public String getPolicy() {
        return policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public String getProxyHost() {
        return proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public Protocol getProxyProtocol() {
        return proxyProtocol;
    }

    public void setProxyProtocol(Protocol proxyProtocol) {
        this.proxyProtocol = proxyProtocol;
    }

    public String getQueueUrl() {
        return queueUrl;
    }

    public void setQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
    }

    public String getRegion() {
        return region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public Boolean getServerSideEncryptionEnabled() {
        return serverSideEncryptionEnabled;
    }

    public void setServerSideEncryptionEnabled(
            Boolean serverSideEncryptionEnabled) {
        this.serverSideEncryptionEnabled = serverSideEncryptionEnabled;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Boolean getSubscribeSNStoSQS() {
        return subscribeSNStoSQS;
    }

    public void setSubscribeSNStoSQS(Boolean subscribeSNStoSQS) {
        this.subscribeSNStoSQS = subscribeSNStoSQS;
    }

    public Boolean getBasicPropertyBinding() {
        return basicPropertyBinding;
    }

    public void setBasicPropertyBinding(Boolean basicPropertyBinding) {
        this.basicPropertyBinding = basicPropertyBinding;
    }

    public String getAccessKey() {
        return accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }
}