/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.s3.springboot;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws2.s3.AWS2S3Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;

public class AWS2S3ComponentConverter
implements GenericConverter {
    private final CamelContext camelContext;

    public AWS2S3ComponentConverter(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, S3Client.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, S3Presigner.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, AWS2S3Configuration.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "software.amazon.awssdk.services.s3.S3Client": {
                return this.camelContext.getRegistry().lookupByNameAndType(ref, S3Client.class);
            }
            case "software.amazon.awssdk.services.s3.presigner.S3Presigner": {
                return this.camelContext.getRegistry().lookupByNameAndType(ref, S3Presigner.class);
            }
            case "org.apache.camel.component.aws2.s3.AWS2S3Configuration": {
                return this.camelContext.getRegistry().lookupByNameAndType(ref, AWS2S3Configuration.class);
            }
        }
        return null;
    }
}

