/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.ses.springboot;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.component.aws2.ses.Ses2Configuration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;
import software.amazon.awssdk.services.ses.SesClient;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class Ses2ComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, SesClient.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, Ses2Configuration.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "software.amazon.awssdk.services.ses.SesClient": {
                return this.applicationContext.getBean(ref, SesClient.class);
            }
            case "org.apache.camel.component.aws2.ses.Ses2Configuration": {
                return this.applicationContext.getBean(ref, Ses2Configuration.class);
            }
        }
        return null;
    }
}

