/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws2.sqs.springboot;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.component.aws2.sqs.Sqs2Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import software.amazon.awssdk.services.sqs.SqsClient;

public class Sqs2ComponentConverter
implements GenericConverter {
    private final CamelContext camelContext;

    public Sqs2ComponentConverter(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, SqsClient.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, Sqs2Configuration.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "software.amazon.awssdk.services.sqs.SqsClient": {
                return this.camelContext.getRegistry().lookupByNameAndType(ref, SqsClient.class);
            }
            case "org.apache.camel.component.aws2.sqs.Sqs2Configuration": {
                return this.camelContext.getRegistry().lookupByNameAndType(ref, Sqs2Configuration.class);
            }
        }
        return null;
    }
}

