/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.eventhubs.springboot;

import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import com.azure.storage.common.StorageSharedKeyCredential;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.component.azure.eventhubs.EventHubsConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class EventHubsComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, AmqpRetryOptions.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, EventHubsConfiguration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, StorageSharedKeyCredential.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, CheckpointStore.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, EventHubProducerAsyncClient.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "com.azure.core.amqp.AmqpRetryOptions": {
                return this.applicationContext.getBean(ref, AmqpRetryOptions.class);
            }
            case "org.apache.camel.component.azure.eventhubs.EventHubsConfiguration": {
                return this.applicationContext.getBean(ref, EventHubsConfiguration.class);
            }
            case "com.azure.storage.common.StorageSharedKeyCredential": {
                return this.applicationContext.getBean(ref, StorageSharedKeyCredential.class);
            }
            case "com.azure.messaging.eventhubs.CheckpointStore": {
                return this.applicationContext.getBean(ref, CheckpointStore.class);
            }
            case "com.azure.messaging.eventhubs.EventHubProducerAsyncClient": {
                return this.applicationContext.getBean(ref, EventHubProducerAsyncClient.class);
            }
        }
        return null;
    }
}

