/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.azure.eventhubs.springboot;

import java.util.Map;
import com.azure.core.amqp.AmqpRetryOptions;
import com.azure.core.amqp.AmqpTransportType;
import com.azure.core.credential.TokenCredential;
import com.azure.messaging.eventhubs.CheckpointStore;
import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import com.azure.messaging.eventhubs.models.EventPosition;
import com.azure.storage.common.StorageSharedKeyCredential;
import org.apache.camel.component.azure.eventhubs.CredentialType;
import org.apache.camel.component.azure.eventhubs.EventHubsComponent;
import org.apache.camel.component.azure.eventhubs.EventHubsConfiguration;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Send and receive events to/from Azure Event Hubs using AMQP protocol.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@ConfigurationProperties(prefix = "camel.component.azure-eventhubs")
public class EventHubsComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the azure-eventhubs component.
     * This is enabled by default.
     */
    private Boolean enabled;
    /**
     * Sets the retry policy for EventHubAsyncClient. If not specified, the
     * default retry options are used. The option is a
     * com.azure.core.amqp.AmqpRetryOptions type.
     */
    private AmqpRetryOptions amqpRetryOptions;
    /**
     * Sets the transport type by which all the communication with Azure Event
     * Hubs occurs. Default value is AmqpTransportType#AMQP.
     */
    private AmqpTransportType amqpTransportType = AmqpTransportType.AMQP;
    /**
     * The component configurations. The option is a
     * org.apache.camel.component.azure.eventhubs.EventHubsConfiguration type.
     */
    private EventHubsConfiguration configuration;
    /**
     * In case you chose the default BlobCheckpointStore, this sets access key
     * for the associated azure account name to be used for authentication with
     * azure blob services.
     */
    private String blobAccessKey;
    /**
     * In case you chose the default BlobCheckpointStore, this sets Azure
     * account name to be used for authentication with azure blob services.
     */
    private String blobAccountName;
    /**
     * In case you chose the default BlobCheckpointStore, this sets the blob
     * container that shall be used by the BlobCheckpointStore to store the
     * checkpoint offsets.
     */
    private String blobContainerName;
    /**
     * In case you chose the default BlobCheckpointStore,
     * StorageSharedKeyCredential can be injected to create the azure client,
     * this holds the important authentication information. The option is a
     * com.azure.storage.common.StorageSharedKeyCredential type.
     */
    private StorageSharedKeyCredential blobStorageSharedKeyCredential;
    /**
     * Allows for bridging the consumer to the Camel routing Error Handler,
     * which mean any exceptions (if possible) occurred while the Camel consumer
     * is trying to pickup incoming messages, or the likes, will now be
     * processed as a message and handled by the routing Error Handler.
     * Important: This is only possible if the 3rd party component allows Camel
     * to be alerted if an exception was thrown. Some components handle this
     * internally only, and therefore bridgeErrorHandler is not possible. In
     * other situations we may improve the Camel component to hook into the 3rd
     * party component and make this possible for future releases. By default
     * the consumer will use the org.apache.camel.spi.ExceptionHandler to deal
     * with exceptions, that will be logged at WARN or ERROR level and ignored.
     */
    private Boolean bridgeErrorHandler = false;
    /**
     * Sets the batch size between each checkpoint updates. Works jointly with
     * checkpointBatchTimeout.
     */
    private Integer checkpointBatchSize = 500;
    /**
     * Sets the batch timeout between each checkpoint updates. Works jointly
     * with checkpointBatchSize.
     */
    private Integer checkpointBatchTimeout = 5000;
    /**
     * Sets the CheckpointStore the EventProcessorClient will use for storing
     * partition ownership and checkpoint information. Users can, optionally,
     * provide their own implementation of CheckpointStore which will store
     * ownership and checkpoint information. By default it set to use
     * com.azure.messaging.eventhubs.checkpointstore.blob.BlobCheckpointStore
     * which stores all checkpoint offsets into Azure Blob Storage. The option
     * is a com.azure.messaging.eventhubs.CheckpointStore type.
     */
    private CheckpointStore checkpointStore;
    /**
     * Sets the name of the consumer group this consumer is associated with.
     * Events are read in the context of this group. The name of the consumer
     * group that is created by default is {code $Default}.
     */
    private String consumerGroupName = "$Default";
    /**
     * Sets the map containing the event position to use for each partition if a
     * checkpoint for the partition does not exist in CheckpointStore. This map
     * is keyed off of the partition id. If there is no checkpoint in
     * CheckpointStore and there is no entry in this map, the processing of the
     * partition will start from {link EventPosition#latest() latest} position.
     */
    private Map<String, EventPosition> eventPosition;
    /**
     * Sets the count used by the receiver to control the number of events the
     * Event Hub consumer will actively receive and queue locally without regard
     * to whether a receive operation is currently active.
     */
    private Integer prefetchCount = 500;
    /**
     * Whether the producer should be started lazy (on the first message). By
     * starting lazy you can use this to allow CamelContext and routes to
     * startup in situations where a producer may otherwise fail during starting
     * and cause the route to fail being started. By deferring this startup to
     * be lazy then the startup failure can be handled during routing messages
     * via Camel's routing error handlers. Beware that when the first message is
     * processed then creating and starting the producer may take a little time
     * and prolong the total processing time of the processing.
     */
    private Boolean lazyStartProducer = false;
    /**
     * Sets the identifier of the Event Hub partition that the events will be
     * sent to. If the identifier is not specified, the Event Hubs service will
     * be responsible for routing events that are sent to an available
     * partition.
     */
    private String partitionId;
    /**
     * Sets a hashing key to be provided for the batch of events, which
     * instructs the Event Hubs service to map this key to a specific partition.
     * The selection of a partition is stable for a given partition hashing key.
     * Should any other batches of events be sent using the same exact partition
     * hashing key, the Event Hubs service will route them all to the same
     * partition. This should be specified only when there is a need to group
     * events by partition, but there is flexibility into which partition they
     * are routed. If ensuring that a batch of events is sent only to a specific
     * partition, it is recommended that the {link #setPartitionId(String)
     * identifier of the position be specified directly} when sending the batch.
     */
    private String partitionKey;
    /**
     * Sets the EventHubProducerAsyncClient.An asynchronous producer responsible
     * for transmitting EventData to a specific Event Hub, grouped together in
     * batches. Depending on the options specified when creating an
     * {linkEventDataBatch}, the events may be automatically routed to an
     * available partition or specific to a partition. Use by this component to
     * produce the data in camel producer. The option is a
     * com.azure.messaging.eventhubs.EventHubProducerAsyncClient type.
     */
    private EventHubProducerAsyncClient producerAsyncClient;
    /**
     * Whether autowiring is enabled. This is used for automatic autowiring
     * options (the option must be marked as autowired) by looking up in the
     * registry to find if there is a single instance of matching type, which
     * then gets configured on the component. This can be used for automatic
     * configuring JDBC data sources, JMS connection factories, AWS Clients,
     * etc.
     */
    private Boolean autowiredEnabled = true;
    /**
     * Instead of supplying namespace, sharedAccessKey, sharedAccessName ...
     * etc, you can just supply the connection string for your eventHub. The
     * connection string for EventHubs already include all the necessary
     * information to connection to your EventHub. To learn on how to generate
     * the connection string, take a look at this documentation:
     * https://docs.microsoft.com/en-us/azure/event-hubs/event-hubs-get-connection-string
     */
    private String connectionString;
    /**
     * Determines the credential strategy to adopt
     */
    private CredentialType credentialType = CredentialType.CONNECTION_STRING;
    /**
     * The generated value for the SharedAccessName.
     */
    private String sharedAccessKey;
    /**
     * The name you chose for your EventHubs SAS keys.
     */
    private String sharedAccessName;
    /**
     * Still another way of authentication (beside supplying namespace,
     * sharedAccessKey, sharedAccessName or connection string) is through
     * Azure-AD authentication using an implementation instance of
     * TokenCredential. The option is a
     * com.azure.core.credential.TokenCredential type.
     */
    private TokenCredential tokenCredential;

    public AmqpRetryOptions getAmqpRetryOptions() {
        return amqpRetryOptions;
    }

    public void setAmqpRetryOptions(AmqpRetryOptions amqpRetryOptions) {
        this.amqpRetryOptions = amqpRetryOptions;
    }

    public AmqpTransportType getAmqpTransportType() {
        return amqpTransportType;
    }

    public void setAmqpTransportType(AmqpTransportType amqpTransportType) {
        this.amqpTransportType = amqpTransportType;
    }

    public EventHubsConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(EventHubsConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getBlobAccessKey() {
        return blobAccessKey;
    }

    public void setBlobAccessKey(String blobAccessKey) {
        this.blobAccessKey = blobAccessKey;
    }

    public String getBlobAccountName() {
        return blobAccountName;
    }

    public void setBlobAccountName(String blobAccountName) {
        this.blobAccountName = blobAccountName;
    }

    public String getBlobContainerName() {
        return blobContainerName;
    }

    public void setBlobContainerName(String blobContainerName) {
        this.blobContainerName = blobContainerName;
    }

    public StorageSharedKeyCredential getBlobStorageSharedKeyCredential() {
        return blobStorageSharedKeyCredential;
    }

    public void setBlobStorageSharedKeyCredential(
            StorageSharedKeyCredential blobStorageSharedKeyCredential) {
        this.blobStorageSharedKeyCredential = blobStorageSharedKeyCredential;
    }

    public Boolean getBridgeErrorHandler() {
        return bridgeErrorHandler;
    }

    public void setBridgeErrorHandler(Boolean bridgeErrorHandler) {
        this.bridgeErrorHandler = bridgeErrorHandler;
    }

    public Integer getCheckpointBatchSize() {
        return checkpointBatchSize;
    }

    public void setCheckpointBatchSize(Integer checkpointBatchSize) {
        this.checkpointBatchSize = checkpointBatchSize;
    }

    public Integer getCheckpointBatchTimeout() {
        return checkpointBatchTimeout;
    }

    public void setCheckpointBatchTimeout(Integer checkpointBatchTimeout) {
        this.checkpointBatchTimeout = checkpointBatchTimeout;
    }

    public CheckpointStore getCheckpointStore() {
        return checkpointStore;
    }

    public void setCheckpointStore(CheckpointStore checkpointStore) {
        this.checkpointStore = checkpointStore;
    }

    public String getConsumerGroupName() {
        return consumerGroupName;
    }

    public void setConsumerGroupName(String consumerGroupName) {
        this.consumerGroupName = consumerGroupName;
    }

    public Map<String, EventPosition> getEventPosition() {
        return eventPosition;
    }

    public void setEventPosition(Map<String, EventPosition> eventPosition) {
        this.eventPosition = eventPosition;
    }

    public Integer getPrefetchCount() {
        return prefetchCount;
    }

    public void setPrefetchCount(Integer prefetchCount) {
        this.prefetchCount = prefetchCount;
    }

    public Boolean getLazyStartProducer() {
        return lazyStartProducer;
    }

    public void setLazyStartProducer(Boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public String getPartitionId() {
        return partitionId;
    }

    public void setPartitionId(String partitionId) {
        this.partitionId = partitionId;
    }

    public String getPartitionKey() {
        return partitionKey;
    }

    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    public EventHubProducerAsyncClient getProducerAsyncClient() {
        return producerAsyncClient;
    }

    public void setProducerAsyncClient(
            EventHubProducerAsyncClient producerAsyncClient) {
        this.producerAsyncClient = producerAsyncClient;
    }

    public Boolean getAutowiredEnabled() {
        return autowiredEnabled;
    }

    public void setAutowiredEnabled(Boolean autowiredEnabled) {
        this.autowiredEnabled = autowiredEnabled;
    }

    public String getConnectionString() {
        return connectionString;
    }

    public void setConnectionString(String connectionString) {
        this.connectionString = connectionString;
    }

    public CredentialType getCredentialType() {
        return credentialType;
    }

    public void setCredentialType(CredentialType credentialType) {
        this.credentialType = credentialType;
    }

    public String getSharedAccessKey() {
        return sharedAccessKey;
    }

    public void setSharedAccessKey(String sharedAccessKey) {
        this.sharedAccessKey = sharedAccessKey;
    }

    public String getSharedAccessName() {
        return sharedAccessName;
    }

    public void setSharedAccessName(String sharedAccessName) {
        this.sharedAccessName = sharedAccessName;
    }

    public TokenCredential getTokenCredential() {
        return tokenCredential;
    }

    public void setTokenCredential(TokenCredential tokenCredential) {
        this.tokenCredential = tokenCredential;
    }
}