/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.crypto.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.converter.crypto.CryptoDataFormat;
import org.apache.camel.converter.crypto.springboot.CryptoDataFormatConfiguration;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatCustomizer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.DataFormatConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@EnableConfigurationProperties(value={DataFormatConfigurationProperties.class, CryptoDataFormatConfiguration.class})
@ConditionalOnHierarchicalProperties(value={"camel.dataformat", "camel.dataformat.crypto"})
public class CryptoDataFormatAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    private final CamelContext camelContext;
    @Autowired
    private CryptoDataFormatConfiguration configuration;

    public CryptoDataFormatAutoConfiguration(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Lazy
    @Bean
    public DataFormatCustomizer configureCryptoDataFormatFactory() {
        return new DataFormatCustomizer(){

            public void configure(String name, DataFormat target) {
                CamelPropertiesHelper.copyProperties((CamelContext)CryptoDataFormatAutoConfiguration.this.camelContext, (Object)((Object)CryptoDataFormatAutoConfiguration.this.configuration), (Object)target);
            }

            public boolean isEnabled(String name, DataFormat target) {
                return HierarchicalPropertiesEvaluator.evaluate((ApplicationContext)CryptoDataFormatAutoConfiguration.this.applicationContext, (String[])new String[]{"camel.dataformat.customizer", "camel.dataformat.crypto.customizer"}) && target instanceof CryptoDataFormat;
            }
        };
    }
}

