/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.crypto.springboot;

import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.component.crypto.DigitalSignatureConfiguration;
import org.apache.camel.support.jsse.KeyStoreParameters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class DigitalSignatureComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, KeyStore.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, PrivateKey.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, Certificate.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, DigitalSignatureConfiguration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, KeyStoreParameters.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, PublicKey.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, SecureRandom.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "java.security.KeyStore": {
                return this.applicationContext.getBean(ref, KeyStore.class);
            }
            case "java.security.PrivateKey": {
                return this.applicationContext.getBean(ref, PrivateKey.class);
            }
            case "java.security.cert.Certificate": {
                return this.applicationContext.getBean(ref, Certificate.class);
            }
            case "org.apache.camel.component.crypto.DigitalSignatureConfiguration": {
                return this.applicationContext.getBean(ref, DigitalSignatureConfiguration.class);
            }
            case "org.apache.camel.support.jsse.KeyStoreParameters": {
                return this.applicationContext.getBean(ref, KeyStoreParameters.class);
            }
            case "java.security.PublicKey": {
                return this.applicationContext.getBean(ref, PublicKey.class);
            }
            case "java.security.SecureRandom": {
                return this.applicationContext.getBean(ref, SecureRandom.class);
            }
        }
        return null;
    }
}

