/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.csv.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.dataformat.csv.CsvDataFormat;
import org.apache.camel.dataformat.csv.springboot.CsvDataFormatConfiguration;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatCustomizer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.DataFormatConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@EnableConfigurationProperties(value={DataFormatConfigurationProperties.class, CsvDataFormatConfiguration.class})
@ConditionalOnHierarchicalProperties(value={"camel.dataformat", "camel.dataformat.csv"})
public class CsvDataFormatAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private CamelContext camelContext;
    @Autowired
    private CsvDataFormatConfiguration configuration;

    @Lazy
    @Bean
    public DataFormatCustomizer configureCsvDataFormatFactory() {
        return new DataFormatCustomizer(){

            public void configure(String name, DataFormat target) {
                CamelPropertiesHelper.copyProperties((CamelContext)CsvDataFormatAutoConfiguration.this.camelContext, (Object)((Object)CsvDataFormatAutoConfiguration.this.configuration), (Object)target);
            }

            public boolean isEnabled(String name, DataFormat target) {
                return HierarchicalPropertiesEvaluator.evaluate((ApplicationContext)CsvDataFormatAutoConfiguration.this.applicationContext, (String[])new String[]{"camel.dataformat.customizer", "camel.dataformat.csv.customizer"}) && target instanceof CsvDataFormat;
            }
        };
    }
}

