/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docker.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.component.docker.DockerComponent;
import org.apache.camel.component.docker.springboot.DockerComponentConfiguration;
import org.apache.camel.component.docker.springboot.DockerComponentConverter;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.ComponentConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@EnableConfigurationProperties(value={ComponentConfigurationProperties.class, DockerComponentConfiguration.class})
@ConditionalOnHierarchicalProperties(value={"camel.component", "camel.component.docker"})
@AutoConfigureAfter(value={CamelAutoConfiguration.class, DockerComponentConverter.class})
public class DockerComponentAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    private final CamelContext camelContext;
    @Autowired
    private DockerComponentConfiguration configuration;

    public DockerComponentAutoConfiguration(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Lazy
    @Bean
    public ComponentCustomizer configureDockerComponent() {
        return new ComponentCustomizer(){

            public void configure(String name, Component target) {
                CamelPropertiesHelper.copyProperties((CamelContext)DockerComponentAutoConfiguration.this.camelContext, (Object)((Object)DockerComponentAutoConfiguration.this.configuration), (Object)target);
            }

            public boolean isEnabled(String name, Component target) {
                return HierarchicalPropertiesEvaluator.evaluate((ApplicationContext)DockerComponentAutoConfiguration.this.applicationContext, (String[])new String[]{"camel.component.customizer", "camel.component.docker.customizer"}) && target instanceof DockerComponent;
            }
        };
    }
}

