/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ehcache.springboot;

import java.util.LinkedHashSet;
import java.util.Set;
import org.ehcache.CacheManager;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@org.springframework.context.annotation.Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class EhcacheComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, CacheManager.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, Configuration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, CacheConfiguration.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "org.ehcache.CacheManager": {
                return this.applicationContext.getBean(ref, CacheManager.class);
            }
            case "org.ehcache.config.Configuration": {
                return this.applicationContext.getBean(ref, Configuration.class);
            }
            case "org.ehcache.config.CacheConfiguration": {
                return this.applicationContext.getBean(ref, CacheConfiguration.class);
            }
        }
        return null;
    }
}

