/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ehcache.springboot.customizer;

import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.component.ehcache.EhcacheComponent;
import org.apache.camel.component.ehcache.springboot.customizer.CacheConfigurationCustomizerConfiguration;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spi.HasId;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties;
import org.ehcache.config.CacheConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnBean(value={CamelAutoConfiguration.class})
@ConditionalOnHierarchicalProperties(value={"camel.component.customizer", "camel.component.ehcache.customizer", "camel.component.ehcache.customizer.cache-configuration"})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@EnableConfigurationProperties(value={CacheConfigurationCustomizerConfiguration.class})
public class CacheConfigurationCustomizer
implements HasId,
ComponentCustomizer {
    @Autowired(required=false)
    private Map<String, CacheConfiguration> configurations;
    @Autowired
    private CacheConfigurationCustomizerConfiguration configuration;

    public void configure(String name, Component target) {
        EhcacheComponent component = (EhcacheComponent)target;
        if (this.configurations != null && this.configuration.getMode() == CacheConfigurationCustomizerConfiguration.Mode.APPEND) {
            component.addCachesConfigurations(this.configurations);
        }
        if (this.configurations != null && this.configuration.getMode() == CacheConfigurationCustomizerConfiguration.Mode.REPLACE) {
            component.setCachesConfigurations(this.configurations);
        }
    }

    public boolean isEnabled(String name, Component target) {
        return target instanceof EhcacheComponent;
    }

    public int getOrder() {
        return 2147482647;
    }

    public String getId() {
        return "camel.component.ehcache.customizer.cache-configuration";
    }
}

