/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.flatpack.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.dataformat.flatpack.FlatpackDataFormat;
import org.apache.camel.dataformat.flatpack.springboot.FlatpackDataFormatConfiguration;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatCustomizer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.DataFormatConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@EnableConfigurationProperties(value={DataFormatConfigurationProperties.class, FlatpackDataFormatConfiguration.class})
@ConditionalOnHierarchicalProperties(value={"camel.dataformat", "camel.dataformat.flatpack"})
public class FlatpackDataFormatAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    private final CamelContext camelContext;
    @Autowired
    private FlatpackDataFormatConfiguration configuration;

    public FlatpackDataFormatAutoConfiguration(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Lazy
    @Bean
    public DataFormatCustomizer configureFlatpackDataFormatFactory() {
        return new DataFormatCustomizer(){

            public void configure(String name, DataFormat target) {
                CamelPropertiesHelper.copyProperties((CamelContext)FlatpackDataFormatAutoConfiguration.this.camelContext, (Object)((Object)FlatpackDataFormatAutoConfiguration.this.configuration), (Object)target);
            }

            public boolean isEnabled(String name, DataFormat target) {
                return HierarchicalPropertiesEvaluator.evaluate((ApplicationContext)FlatpackDataFormatAutoConfiguration.this.applicationContext, (String[])new String[]{"camel.dataformat.customizer", "camel.dataformat.flatpack.customizer"}) && target instanceof FlatpackDataFormat;
            }
        };
    }
}

