/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jetty12.springboot;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.http.common.HttpBinding;
import org.apache.camel.http.common.HttpConfiguration;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.eclipse.jetty.jmx.MBeanContainer;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class JettyHttpComponentConverter12
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, ThreadPool.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ErrorHandler.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, HttpBinding.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, HttpConfiguration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, MBeanContainer.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, HeaderFilterStrategy.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, SSLContextParameters.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "org.eclipse.jetty.util.thread.ThreadPool": {
                return this.applicationContext.getBean(ref, ThreadPool.class);
            }
            case "org.eclipse.jetty.server.handler.ErrorHandler": {
                return this.applicationContext.getBean(ref, ErrorHandler.class);
            }
            case "org.apache.camel.http.common.HttpBinding": {
                return this.applicationContext.getBean(ref, HttpBinding.class);
            }
            case "org.apache.camel.http.common.HttpConfiguration": {
                return this.applicationContext.getBean(ref, HttpConfiguration.class);
            }
            case "org.eclipse.jetty.jmx.MBeanContainer": {
                return this.applicationContext.getBean(ref, MBeanContainer.class);
            }
            case "org.apache.camel.spi.HeaderFilterStrategy": {
                return this.applicationContext.getBean(ref, HeaderFilterStrategy.class);
            }
            case "org.apache.camel.support.jsse.SSLContextParameters": {
                return this.applicationContext.getBean(ref, SSLContextParameters.class);
            }
        }
        return null;
    }
}

