/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jgroups.springboot.cluster.springboot;

import java.util.Optional;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.component.jgroups.cluster.JGroupsLockClusterService;
import org.apache.camel.component.jgroups.springboot.cluster.springboot.JGroupsLockClusterServiceConfiguration;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.cluster.ClusteredRouteControllerAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@AutoConfigureBefore(value={ClusteredRouteControllerAutoConfiguration.class, CamelAutoConfiguration.class})
@ConditionalOnProperty(prefix="camel.cluster.jgroups", name={"enabled"})
@EnableConfigurationProperties(value={JGroupsLockClusterServiceConfiguration.class})
public class JGroupsLockClusterServiceAutoConfiguration {
    @Autowired
    private JGroupsLockClusterServiceConfiguration configuration;

    @Bean(name={"jgroups-lock-cluster-service"})
    @Scope(value="singleton")
    public CamelClusterService zookeeperClusterService() throws Exception {
        JGroupsLockClusterService service = new JGroupsLockClusterService();
        Optional.ofNullable(this.configuration.getId()).ifPresent(arg_0 -> ((JGroupsLockClusterService)service).setId(arg_0));
        Optional.ofNullable(this.configuration.getJgroupsClusterName()).ifPresent(arg_0 -> ((JGroupsLockClusterService)service).setJgroupsClusterName(arg_0));
        Optional.ofNullable(this.configuration.getJgroupsConfig()).ifPresent(arg_0 -> ((JGroupsLockClusterService)service).setJgroupsConfig(arg_0));
        return service;
    }
}

