/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jpa.springboot;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import org.apache.camel.CamelContext;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.transaction.PlatformTransactionManager;

public class JpaComponentConverter
implements GenericConverter {
    private final CamelContext camelContext;

    public JpaComponentConverter(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, EntityManagerFactory.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, PlatformTransactionManager.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "javax.persistence.EntityManagerFactory": {
                return this.camelContext.getRegistry().lookupByNameAndType(ref, EntityManagerFactory.class);
            }
            case "org.springframework.transaction.PlatformTransactionManager": {
                return this.camelContext.getRegistry().lookupByNameAndType(ref, PlatformTransactionManager.class);
            }
        }
        return null;
    }
}

