/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kafka.springboot;

import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.camel.component.kafka.KafkaClientFactory;
import org.apache.camel.component.kafka.KafkaConfiguration;
import org.apache.camel.component.kafka.KafkaManualCommitFactory;
import org.apache.camel.component.kafka.PollExceptionStrategy;
import org.apache.camel.component.kafka.serde.KafkaHeaderDeserializer;
import org.apache.camel.component.kafka.serde.KafkaHeaderSerializer;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.StateRepository;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class KafkaComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, KafkaConfiguration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, HeaderFilterStrategy.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, KafkaHeaderDeserializer.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, StateRepository.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, KafkaManualCommitFactory.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, PollExceptionStrategy.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, KafkaHeaderSerializer.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ExecutorService.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, KafkaClientFactory.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, SSLContextParameters.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "org.apache.camel.component.kafka.KafkaConfiguration": {
                return this.applicationContext.getBean(ref, KafkaConfiguration.class);
            }
            case "org.apache.camel.spi.HeaderFilterStrategy": {
                return this.applicationContext.getBean(ref, HeaderFilterStrategy.class);
            }
            case "org.apache.camel.component.kafka.serde.KafkaHeaderDeserializer": {
                return this.applicationContext.getBean(ref, KafkaHeaderDeserializer.class);
            }
            case "org.apache.camel.spi.StateRepository": {
                return this.applicationContext.getBean(ref, StateRepository.class);
            }
            case "org.apache.camel.component.kafka.KafkaManualCommitFactory": {
                return this.applicationContext.getBean(ref, KafkaManualCommitFactory.class);
            }
            case "org.apache.camel.component.kafka.PollExceptionStrategy": {
                return this.applicationContext.getBean(ref, PollExceptionStrategy.class);
            }
            case "org.apache.camel.component.kafka.serde.KafkaHeaderSerializer": {
                return this.applicationContext.getBean(ref, KafkaHeaderSerializer.class);
            }
            case "java.util.concurrent.ExecutorService": {
                return this.applicationContext.getBean(ref, ExecutorService.class);
            }
            case "org.apache.camel.component.kafka.KafkaClientFactory": {
                return this.applicationContext.getBean(ref, KafkaClientFactory.class);
            }
            case "org.apache.camel.support.jsse.SSLContextParameters": {
                return this.applicationContext.getBean(ref, SSLContextParameters.class);
            }
        }
        return null;
    }
}

