/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.nodes.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.component.kubernetes.nodes.KubernetesNodesComponent;
import org.apache.camel.component.kubernetes.nodes.springboot.KubernetesNodesComponentConfiguration;
import org.apache.camel.component.kubernetes.nodes.springboot.KubernetesNodesComponentConverter;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.ComponentConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@EnableConfigurationProperties(value={ComponentConfigurationProperties.class, KubernetesNodesComponentConfiguration.class})
@ConditionalOnHierarchicalProperties(value={"camel.component", "camel.component.kubernetes-nodes"})
@AutoConfigureAfter(value={CamelAutoConfiguration.class, KubernetesNodesComponentConverter.class})
public class KubernetesNodesComponentAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    private final CamelContext camelContext;
    @Autowired
    private KubernetesNodesComponentConfiguration configuration;

    public KubernetesNodesComponentAutoConfiguration(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Lazy
    @Bean
    public ComponentCustomizer configureKubernetesNodesComponent() {
        return new ComponentCustomizer(){

            public void configure(String name, Component target) {
                CamelPropertiesHelper.copyProperties((CamelContext)KubernetesNodesComponentAutoConfiguration.this.camelContext, (Object)((Object)KubernetesNodesComponentAutoConfiguration.this.configuration), (Object)target);
            }

            public boolean isEnabled(String name, Component target) {
                return HierarchicalPropertiesEvaluator.evaluate((ApplicationContext)KubernetesNodesComponentAutoConfiguration.this.applicationContext, (String[])new String[]{"camel.component.customizer", "camel.component.kubernetes-nodes.customizer"}) && target instanceof KubernetesNodesComponent;
            }
        };
    }
}

