/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.secrets.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.component.kubernetes.secrets.KubernetesSecretsComponent;
import org.apache.camel.component.kubernetes.secrets.springboot.KubernetesSecretsComponentConfiguration;
import org.apache.camel.component.kubernetes.secrets.springboot.KubernetesSecretsComponentConverter;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.ComponentConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@EnableConfigurationProperties(value={ComponentConfigurationProperties.class, KubernetesSecretsComponentConfiguration.class})
@ConditionalOnHierarchicalProperties(value={"camel.component", "camel.component.kubernetes-secrets"})
@AutoConfigureAfter(value={CamelAutoConfiguration.class, KubernetesSecretsComponentConverter.class})
public class KubernetesSecretsComponentAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    private final CamelContext camelContext;
    @Autowired
    private KubernetesSecretsComponentConfiguration configuration;

    public KubernetesSecretsComponentAutoConfiguration(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Lazy
    @Bean
    public ComponentCustomizer configureKubernetesSecretsComponent() {
        return new ComponentCustomizer(){

            public void configure(String name, Component target) {
                CamelPropertiesHelper.copyProperties((CamelContext)KubernetesSecretsComponentAutoConfiguration.this.camelContext, (Object)((Object)KubernetesSecretsComponentAutoConfiguration.this.configuration), (Object)target);
            }

            public boolean isEnabled(String name, Component target) {
                return HierarchicalPropertiesEvaluator.evaluate((ApplicationContext)KubernetesSecretsComponentAutoConfiguration.this.applicationContext, (String[])new String[]{"camel.component.customizer", "camel.component.kubernetes-secrets.customizer"}) && target instanceof KubernetesSecretsComponent;
            }
        };
    }
}

