/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.services.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.component.kubernetes.services.KubernetesServicesComponent;
import org.apache.camel.component.kubernetes.services.springboot.KubernetesServicesComponentConfiguration;
import org.apache.camel.component.kubernetes.services.springboot.KubernetesServicesComponentConverter;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.ComponentConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@EnableConfigurationProperties(value={ComponentConfigurationProperties.class, KubernetesServicesComponentConfiguration.class})
@ConditionalOnHierarchicalProperties(value={"camel.component", "camel.component.kubernetes-services"})
@AutoConfigureAfter(value={CamelAutoConfiguration.class, KubernetesServicesComponentConverter.class})
public class KubernetesServicesComponentAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    private final CamelContext camelContext;
    @Autowired
    private KubernetesServicesComponentConfiguration configuration;

    public KubernetesServicesComponentAutoConfiguration(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Lazy
    @Bean
    public ComponentCustomizer configureKubernetesServicesComponent() {
        return new ComponentCustomizer(){

            public void configure(String name, Component target) {
                CamelPropertiesHelper.copyProperties((CamelContext)KubernetesServicesComponentAutoConfiguration.this.camelContext, (Object)((Object)KubernetesServicesComponentAutoConfiguration.this.configuration), (Object)target);
            }

            public boolean isEnabled(String name, Component target) {
                return HierarchicalPropertiesEvaluator.evaluate((ApplicationContext)KubernetesServicesComponentAutoConfiguration.this.applicationContext, (String[])new String[]{"camel.component.customizer", "camel.component.kubernetes-services.customizer"}) && target instanceof KubernetesServicesComponent;
            }
        };
    }
}

