/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes.springboot.cluster;

import java.util.Optional;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.component.kubernetes.cluster.KubernetesClusterService;
import org.apache.camel.component.kubernetes.springboot.cluster.KubernetesClusterServiceConfiguration;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.cluster.ClusteredRouteControllerAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={ClusteredRouteControllerAutoConfiguration.class, CamelAutoConfiguration.class})
@ConditionalOnProperty(prefix="camel.cluster.kubernetes", name={"enabled"})
@EnableConfigurationProperties(value={KubernetesClusterServiceConfiguration.class})
public class KubernetesClusterServiceAutoConfiguration {
    @Autowired
    private KubernetesClusterServiceConfiguration configuration;

    @Bean(name={"kubernetes-cluster-service"})
    @Scope(value="singleton")
    public CamelClusterService kubernetesClusterService() throws Exception {
        KubernetesClusterService service = new KubernetesClusterService();
        Optional.ofNullable(this.configuration.getId()).ifPresent(arg_0 -> ((KubernetesClusterService)service).setId(arg_0));
        Optional.ofNullable(this.configuration.getRetryPeriodMillis()).ifPresent(arg_0 -> ((KubernetesClusterService)service).setRetryPeriodMillis(arg_0));
        Optional.ofNullable(this.configuration.getOrder()).ifPresent(arg_0 -> ((KubernetesClusterService)service).setOrder(arg_0));
        Optional.ofNullable(this.configuration.getAttributes()).ifPresent(arg_0 -> ((KubernetesClusterService)service).setAttributes(arg_0));
        Optional.ofNullable(this.configuration.getClusterLabels()).ifPresent(arg_0 -> ((KubernetesClusterService)service).setClusterLabels(arg_0));
        Optional.ofNullable(this.configuration.getKubernetesNamespace()).ifPresent(arg_0 -> ((KubernetesClusterService)service).setKubernetesNamespace(arg_0));
        Optional.ofNullable(this.configuration.getConfigMapName()).ifPresent(arg_0 -> ((KubernetesClusterService)service).setConfigMapName(arg_0));
        Optional.ofNullable(this.configuration.getConnectionTimeoutMillis()).ifPresent(arg_0 -> ((KubernetesClusterService)service).setConnectionTimeoutMillis(arg_0));
        Optional.ofNullable(this.configuration.getJitterFactor()).ifPresent(arg_0 -> ((KubernetesClusterService)service).setJitterFactor(arg_0));
        Optional.ofNullable(this.configuration.getLeaseDurationMillis()).ifPresent(arg_0 -> ((KubernetesClusterService)service).setLeaseDurationMillis(arg_0));
        Optional.ofNullable(this.configuration.getMasterUrl()).ifPresent(arg_0 -> ((KubernetesClusterService)service).setMasterUrl(arg_0));
        Optional.ofNullable(this.configuration.getRenewDeadlineMillis()).ifPresent(arg_0 -> ((KubernetesClusterService)service).setRenewDeadlineMillis(arg_0));
        Optional.ofNullable(this.configuration.getPodName()).ifPresent(arg_0 -> ((KubernetesClusterService)service).setPodName(arg_0));
        return service;
    }
}

