/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.master.springboot;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.CamelContext;
import org.apache.camel.cluster.CamelClusterService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;

public class MasterComponentConverter
implements GenericConverter {
    private final CamelContext camelContext;

    public MasterComponentConverter(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, CamelClusterService.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, CamelClusterService.Selector.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "org.apache.camel.cluster.CamelClusterService": {
                return this.camelContext.getRegistry().lookupByNameAndType(ref, CamelClusterService.class);
            }
            case "org.apache.camel.cluster.CamelClusterService.Selector": {
                return this.camelContext.getRegistry().lookupByNameAndType(ref, CamelClusterService.Selector.class);
            }
        }
        return null;
    }
}

