/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.micrometer.springboot;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Optional;
import org.apache.camel.component.micrometer.springboot.metrics.CamelMetricsConfiguration;
import org.apache.camel.http.common.CamelServlet;
import org.apache.camel.http.common.HttpConsumer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.server.observation.DefaultServerRequestObservationConvention;
import org.springframework.http.server.observation.ServerRequestObservationContext;
import org.springframework.http.server.observation.ServerRequestObservationConvention;

@Configuration(proxyBeanMethods=false)
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@ConditionalOnProperty(prefix="camel.metrics", name={"uriTagEnabled"}, havingValue="true")
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
public class MicrometerTagsAutoConfiguration {
    @Bean
    ServerRequestObservationConvention serverRequestObservationConvention(final Optional<CamelServlet> servlet, final CamelMetricsConfiguration configuration) {
        return new DefaultServerRequestObservationConvention(){

            public KeyValues getLowCardinalityKeyValues(ServerRequestObservationContext context) {
                return super.getLowCardinalityKeyValues(context).and(new KeyValue[]{this.custom(context)});
            }

            protected KeyValue custom(ServerRequestObservationContext context) {
                HttpConsumer consumer;
                HttpServletRequest request = (HttpServletRequest)context.getCarrier();
                Object uri = null;
                if (servlet.isPresent() && !configuration.isUriTagDynamic() && (consumer = ((CamelServlet)servlet.get()).getServletResolveConsumerStrategy().resolve(request, ((CamelServlet)servlet.get()).getConsumers())) != null) {
                    uri = consumer.getPath();
                }
                if (uri == null || ((String)uri).isEmpty()) {
                    uri = request.getServletPath();
                    if (uri == null || ((String)uri).isEmpty()) {
                        uri = request.getPathInfo();
                    } else {
                        String p = request.getPathInfo();
                        if (p != null) {
                            uri = (String)uri + p;
                        }
                    }
                }
                if (uri == null) {
                    uri = "";
                }
                return KeyValue.of((String)"uri", (String)((HttpServletRequest)context.getCarrier()).getMethod());
            }
        };
    }
}

