/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.minio.springboot;

import io.minio.MinioClient;
import io.minio.ServerSideEncryption;
import io.minio.ServerSideEncryptionCustomerKey;
import java.util.LinkedHashSet;
import java.util.Set;
import okhttp3.OkHttpClient;
import org.apache.camel.component.minio.MinioConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class MinioComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, MinioConfiguration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, MinioClient.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, OkHttpClient.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ServerSideEncryption.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ServerSideEncryptionCustomerKey.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "org.apache.camel.component.minio.MinioConfiguration": {
                return this.applicationContext.getBean(ref, MinioConfiguration.class);
            }
            case "io.minio.MinioClient": {
                return this.applicationContext.getBean(ref, MinioClient.class);
            }
            case "okhttp3.OkHttpClient": {
                return this.applicationContext.getBean(ref, OkHttpClient.class);
            }
            case "io.minio.ServerSideEncryption": {
                return this.applicationContext.getBean(ref, ServerSideEncryption.class);
            }
            case "io.minio.ServerSideEncryptionCustomerKey": {
                return this.applicationContext.getBean(ref, ServerSideEncryptionCustomerKey.class);
            }
        }
        return null;
    }
}

