/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentelemetry2.starter;

import org.apache.camel.CamelContext;
import org.apache.camel.opentelemetry2.OpenTelemetryTracer;
import org.apache.camel.opentelemetry2.starter.OpenTelemetry2ConfigurationProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={OpenTelemetry2ConfigurationProperties.class})
@ConditionalOnProperty(value={"camel.opentelemetry2.enabled"}, matchIfMissing=true)
public class OpenTelemetry2AutoConfiguration {
    @Bean(initMethod="", destroyMethod="")
    @ConditionalOnMissingBean(value={OpenTelemetryTracer.class})
    OpenTelemetryTracer openTelemetryEventNotifier(CamelContext camelContext, OpenTelemetry2ConfigurationProperties config) {
        OpenTelemetryTracer ottracer = new OpenTelemetryTracer();
        if (config.getExcludePatterns() != null) {
            ottracer.setExcludePatterns(config.getExcludePatterns());
        }
        if (config.getTraceProcessors() != null) {
            ottracer.setTraceProcessors(config.getTraceProcessors().booleanValue());
        }
        ottracer.init(camelContext);
        return ottracer;
    }
}

