/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactive.streams.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.component.reactive.streams.api.CamelReactiveStreamsService;
import org.apache.camel.component.reactive.streams.engine.DefaultCamelReactiveStreamsServiceFactory;
import org.apache.camel.component.reactive.streams.engine.ReactiveStreamsEngineConfiguration;
import org.apache.camel.component.reactive.streams.springboot.ReactiveStreamsComponentAutoConfiguration;
import org.apache.camel.component.reactive.streams.springboot.ReactiveStreamsComponentConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@AutoConfigureAfter(value={ReactiveStreamsComponentAutoConfiguration.class})
@ConditionalOnBean(value={ReactiveStreamsComponentAutoConfiguration.class})
@EnableConfigurationProperties(value={ReactiveStreamsComponentConfiguration.class})
@Configuration
public class ReactiveStreamsServiceAutoConfiguration {
    @Lazy
    @Bean
    @ConditionalOnMissingBean
    public CamelReactiveStreamsService camelReactiveStreamsService(CamelContext context, ReactiveStreamsComponentConfiguration configuration) {
        ReactiveStreamsEngineConfiguration engineConfiguration = new ReactiveStreamsEngineConfiguration();
        if (configuration.getReactiveStreamsEngineConfiguration() != null) {
            engineConfiguration = configuration.getReactiveStreamsEngineConfiguration();
        } else {
            engineConfiguration.setThreadPoolName(configuration.getThreadPoolName());
            if (configuration.getThreadPoolMinSize() != null) {
                engineConfiguration.setThreadPoolMinSize(configuration.getThreadPoolMinSize().intValue());
            }
            if (configuration.getThreadPoolMaxSize() != null) {
                engineConfiguration.setThreadPoolMinSize(configuration.getThreadPoolMaxSize().intValue());
            }
        }
        return new DefaultCamelReactiveStreamsServiceFactory().newInstance(context, engineConfiguration);
    }
}

