/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.springboot;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.jms.ConnectionFactory;
import org.apache.camel.component.sjms.TransactionCommitStrategy;
import org.apache.camel.component.sjms.jms.ConnectionResource;
import org.apache.camel.component.sjms.jms.DestinationCreationStrategy;
import org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy;
import org.apache.camel.component.sjms.jms.MessageCreatedStrategy;
import org.apache.camel.component.sjms.taskmanager.TimedTaskManager;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class SjmsComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, ConnectionFactory.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ConnectionResource.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, DestinationCreationStrategy.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, JmsKeyFormatStrategy.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, MessageCreatedStrategy.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, TimedTaskManager.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, HeaderFilterStrategy.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, TransactionCommitStrategy.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "javax.jms.ConnectionFactory": {
                return this.applicationContext.getBean(ref, ConnectionFactory.class);
            }
            case "org.apache.camel.component.sjms.jms.ConnectionResource": {
                return this.applicationContext.getBean(ref, ConnectionResource.class);
            }
            case "org.apache.camel.component.sjms.jms.DestinationCreationStrategy": {
                return this.applicationContext.getBean(ref, DestinationCreationStrategy.class);
            }
            case "org.apache.camel.component.sjms.jms.JmsKeyFormatStrategy": {
                return this.applicationContext.getBean(ref, JmsKeyFormatStrategy.class);
            }
            case "org.apache.camel.component.sjms.jms.MessageCreatedStrategy": {
                return this.applicationContext.getBean(ref, MessageCreatedStrategy.class);
            }
            case "org.apache.camel.component.sjms.taskmanager.TimedTaskManager": {
                return this.applicationContext.getBean(ref, TimedTaskManager.class);
            }
            case "org.apache.camel.spi.HeaderFilterStrategy": {
                return this.applicationContext.getBean(ref, HeaderFilterStrategy.class);
            }
            case "org.apache.camel.component.sjms.TransactionCommitStrategy": {
                return this.applicationContext.getBean(ref, TransactionCommitStrategy.class);
            }
        }
        return null;
    }
}

