/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot.threadpool;

import org.apache.camel.CamelContext;
import org.apache.camel.builder.ThreadPoolProfileBuilder;
import org.apache.camel.spi.ThreadPoolProfile;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.threadpool.CamelThreadPoolConfigurationProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnBean(value={CamelAutoConfiguration.class})
@EnableConfigurationProperties(value={CamelThreadPoolConfigurationProperties.class})
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
public class CamelThreadPoolAutoConfiguration {
    @Bean
    public ThreadPoolProfile threadPool(CamelContext camelContext, CamelThreadPoolConfigurationProperties tp) {
        ThreadPoolProfile defaultProfile = camelContext.getExecutorServiceManager().getDefaultThreadPoolProfile();
        ThreadPoolProfile dp = new ThreadPoolProfileBuilder("default", defaultProfile).poolSize(tp.getPoolSize()).maxPoolSize(tp.getMaxPoolSize()).keepAliveTime(tp.getKeepAliveTime(), tp.getTimeUnit()).maxQueueSize(tp.getMaxQueueSize()).allowCoreThreadTimeOut(tp.getAllowCoreThreadTimeOut()).rejectedPolicy(tp.getRejectedPolicy()).build();
        tp.getConfig().forEach((k, v) -> {
            ThreadPoolProfileBuilder builder = new ThreadPoolProfileBuilder(k, dp);
            ThreadPoolProfile tpp = builder.poolSize(v.getPoolSize()).maxPoolSize(v.getMaxPoolSize()).keepAliveTime(v.getKeepAliveTime(), v.getTimeUnit()).maxQueueSize(v.getMaxQueueSize()).allowCoreThreadTimeOut(v.getAllowCoreThreadTimeOut()).rejectedPolicy(v.getRejectedPolicy()).build();
            if (!tpp.isEmpty()) {
                camelContext.getExecutorServiceManager().registerThreadPoolProfile(tpp);
            }
        });
        if (!dp.isEmpty()) {
            dp.setDefaultProfile(Boolean.valueOf(true));
            camelContext.getExecutorServiceManager().setDefaultThreadPoolProfile(dp);
        }
        return dp;
    }
}

