/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.boot;

import java.util.Map;
import org.apache.camel.LoggingLevel;
import org.apache.camel.ManagementMBeansLevel;
import org.apache.camel.ManagementStatisticsLevel;
import org.apache.camel.StartupSummaryLevel;
import org.apache.camel.main.DefaultConfigurationProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.DeprecatedConfigurationProperty;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="camel")
public class CamelConfigurationProperties {
    @NestedConfigurationProperty
    private final Main main = new Main();

    public Main getMain() {
        return this.main;
    }

    public class Main
    extends InnerCamelConfigurationProperties {
        private boolean runController;
        @Deprecated
        private boolean mainRunController;
        private boolean includeNonSingletons;
        private boolean warnOnEarlyShutdown = true;

        public boolean isRunController() {
            return this.runController;
        }

        public void setRunController(boolean runController) {
            this.runController = runController;
        }

        @DeprecatedConfigurationProperty(replacement="camel.main.run-controller", since="4.14.0")
        @Deprecated
        public boolean isMainRunController() {
            return this.mainRunController;
        }

        @Deprecated
        public void setMainRunController(boolean mainRunController) {
            this.mainRunController = mainRunController;
        }

        public boolean isIncludeNonSingletons() {
            return this.includeNonSingletons;
        }

        public void setIncludeNonSingletons(boolean includeNonSingletons) {
            this.includeNonSingletons = includeNonSingletons;
        }

        public boolean isWarnOnEarlyShutdown() {
            return this.warnOnEarlyShutdown;
        }

        public void setWarnOnEarlyShutdown(boolean warnOnEarlyShutdown) {
            this.warnOnEarlyShutdown = warnOnEarlyShutdown;
        }
    }

    static class InnerCamelConfigurationProperties
    extends DefaultConfigurationProperties {
        private String name;
        private String description;
        private StartupSummaryLevel startupSummaryLevel;
        private int durationMaxSeconds;
        private int durationMaxIdleSeconds;
        private int durationMaxMessages;
        private String durationMaxAction = "shutdown";
        private int shutdownTimeout = 45;
        private boolean shutdownSuppressLoggingOnTimeout;
        private boolean shutdownNowOnTimeout = true;
        private boolean shutdownRoutesInReverseOrder = true;
        private boolean shutdownLogInflightExchangesOnTimeout = true;
        private boolean inflightRepositoryBrowseEnabled;
        private String fileConfigurations;
        private boolean jmxEnabled = true;
        private String uuidGenerator = "default";
        private int producerTemplateCacheSize = 1000;
        private int consumerTemplateCacheSize = 1000;
        private boolean loadTypeConverters;
        private boolean loadHealthChecks;
        private boolean devConsoleEnabled;
        private boolean modeline;
        private int logDebugMaxChars;
        private boolean streamCachingEnabled = true;
        private String streamCachingAllowClasses;
        private String streamCachingDenyClasses;
        private boolean streamCachingSpoolEnabled;
        private String streamCachingSpoolDirectory;
        private String streamCachingSpoolCipher;
        private long streamCachingSpoolThreshold;
        private int streamCachingSpoolUsedHeapMemoryThreshold;
        private String streamCachingSpoolUsedHeapMemoryLimit;
        private boolean streamCachingAnySpoolRules;
        private int streamCachingBufferSize;
        private boolean streamCachingRemoveSpoolDirectoryWhenStopping = true;
        private boolean streamCachingStatisticsEnabled;
        private boolean typeConverterStatisticsEnabled;
        private boolean tracing;
        private boolean tracingStandby;
        private boolean tracingTemplates;
        private String tracingPattern;
        private String tracingLoggingFormat;
        private boolean messageHistory;
        private boolean sourceLocationEnabled;
        private boolean logMask;
        private boolean logExhaustedMessageBody;
        private String logName;
        private String logLanguage;
        private boolean autoStartup = true;
        private String autoStartupExcludePattern;
        private boolean allowUseOriginalMessage;
        private boolean caseInsensitiveHeaders = true;
        private boolean autowiredEnabled = true;
        private boolean endpointRuntimeStatisticsEnabled;
        private boolean loadStatisticsEnabled;
        private boolean endpointLazyStartProducer;
        private boolean endpointBridgeErrorHandler;
        private boolean useDataType;
        private boolean useBreadcrumb;
        private boolean beanPostProcessorEnabled = true;
        private ManagementMBeansLevel jmxManagementMBeansLevel = ManagementMBeansLevel.Default;
        private ManagementStatisticsLevel jmxManagementStatisticsLevel = ManagementStatisticsLevel.Default;
        private String jmxManagementNamePattern = "#name#";
        private boolean jmxManagementRegisterRoutesCreateByKamelet;
        private boolean jmxManagementRegisterRoutesCreateByTemplate = true;
        private boolean camelEventsTimestampEnabled;
        private boolean useMdcLogging;
        private String mdcLoggingKeysPattern;
        private String threadNamePattern;
        private String routeFilterIncludePattern;
        private String routeFilterExcludePattern;
        private boolean beanIntrospectionExtendedStatistics;
        private LoggingLevel beanIntrospectionLoggingLevel;
        private boolean routesCollectorEnabled = true;
        private boolean routesCollectorIgnoreLoadingError;
        private String compileWorkDir;
        private String javaRoutesIncludePattern;
        private String javaRoutesExcludePattern;
        private String routesIncludePattern = "classpath:camel/*,classpath:camel-template/*,classpath:camel-rest/*";
        private String routesExcludePattern;
        private boolean routesReloadEnabled;
        private boolean contextReloadEnabled;
        private String routesReloadDirectory = "src/main/resources/camel";
        private boolean routesReloadDirectoryRecursive;
        private String routesReloadPattern;
        private boolean routesReloadRemoveAllRoutes = true;
        private boolean routesReloadRestartDuration;
        private boolean jmxUpdateRouteEnabled;
        private String groovyScriptPattern = "classpath:camel-groovy/*,classpath:camel-groovy-compiled/*";
        private boolean groovyPreloadCompiled;
        private String exchangeFactory = "default";
        private int exchangeFactoryCapacity = 100;
        private boolean exchangeFactoryStatisticsEnabled;
        private String dumpRoutes;
        private String dumpRoutesInclude = "routes";
        private boolean dumpRoutesLog = true;
        private boolean dumpRoutesResolvePlaceholders = true;
        private boolean dumpRoutesUriAsParameters;
        private boolean dumpRoutesGeneratedIds;
        private String dumpRoutesOutput;
        private Map globalOptions;
        private String startupRecorder;
        private int startupRecorderMaxDepth = -1;
        private boolean startupRecorderRecording;
        private String startupRecorderProfile = "default";
        private long startupRecorderDuration;
        private String startupRecorderDir;
        private String cloudPropertiesLocation;

        InnerCamelConfigurationProperties() {
        }
    }
}

