/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.jdbc.springboot;

import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.component.spring.jdbc.SpringJdbcComponent;
import org.apache.camel.component.spring.jdbc.springboot.SpringJdbcComponentConfiguration;
import org.apache.camel.component.spring.jdbc.springboot.SpringJdbcComponentConverter;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.ComponentConfigurationProperties;
import org.apache.camel.spring.boot.util.CamelPropertiesHelper;
import org.apache.camel.spring.boot.util.ConditionalOnCamelContextAndAutoConfigurationBeans;
import org.apache.camel.spring.boot.util.ConditionalOnHierarchicalProperties;
import org.apache.camel.spring.boot.util.HierarchicalPropertiesEvaluator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@Conditional(value={ConditionalOnCamelContextAndAutoConfigurationBeans.class})
@EnableConfigurationProperties(value={ComponentConfigurationProperties.class, SpringJdbcComponentConfiguration.class})
@ConditionalOnHierarchicalProperties(value={"camel.component", "camel.component.spring-jdbc"})
@AutoConfigureAfter(value={CamelAutoConfiguration.class, SpringJdbcComponentConverter.class})
public class SpringJdbcComponentAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    private final CamelContext camelContext;
    @Autowired
    private SpringJdbcComponentConfiguration configuration;

    public SpringJdbcComponentAutoConfiguration(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    @Lazy
    @Bean
    public ComponentCustomizer configureSpringJdbcComponent() {
        return new ComponentCustomizer(){

            public void configure(String name, Component target) {
                CamelPropertiesHelper.copyProperties((CamelContext)SpringJdbcComponentAutoConfiguration.this.camelContext, (Object)((Object)SpringJdbcComponentAutoConfiguration.this.configuration), (Object)target);
            }

            public boolean isEnabled(String name, Component target) {
                return HierarchicalPropertiesEvaluator.evaluate((ApplicationContext)SpringJdbcComponentAutoConfiguration.this.applicationContext, (String[])new String[]{"camel.component.customizer", "camel.component.spring-jdbc.customizer"}) && target instanceof SpringJdbcComponent;
            }
        };
    }
}

