/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.stitch.springboot;

import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.component.stitch.StitchConfiguration;
import org.apache.camel.component.stitch.client.StitchClient;
import org.apache.camel.component.stitch.client.models.StitchSchema;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;
import reactor.netty.http.client.HttpClient;
import reactor.netty.resources.ConnectionProvider;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class StitchComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, StitchConfiguration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, StitchSchema.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, ConnectionProvider.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, HttpClient.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, StitchClient.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "org.apache.camel.component.stitch.StitchConfiguration": {
                return this.applicationContext.getBean(ref, StitchConfiguration.class);
            }
            case "org.apache.camel.component.stitch.client.models.StitchSchema": {
                return this.applicationContext.getBean(ref, StitchSchema.class);
            }
            case "reactor.netty.resources.ConnectionProvider": {
                return this.applicationContext.getBean(ref, ConnectionProvider.class);
            }
            case "reactor.netty.http.client.HttpClient": {
                return this.applicationContext.getBean(ref, HttpClient.class);
            }
            case "org.apache.camel.component.stitch.client.StitchClient": {
                return this.applicationContext.getBean(ref, StitchClient.class);
            }
        }
        return null;
    }
}

