/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twilio.springboot;

import com.twilio.http.TwilioRestClient;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.camel.component.twilio.TwilioConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Configuration(proxyBeanMethods=false)
@ConfigurationPropertiesBinding
@Component
public class TwilioComponentConverter
implements GenericConverter {
    @Autowired
    private ApplicationContext applicationContext;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        LinkedHashSet<GenericConverter.ConvertiblePair> answer = new LinkedHashSet<GenericConverter.ConvertiblePair>();
        answer.add(new GenericConverter.ConvertiblePair(String.class, TwilioConfiguration.class));
        answer.add(new GenericConverter.ConvertiblePair(String.class, TwilioRestClient.class));
        return answer;
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "org.apache.camel.component.twilio.TwilioConfiguration": {
                return this.applicationContext.getBean(ref, TwilioConfiguration.class);
            }
            case "com.twilio.http.TwilioRestClient": {
                return this.applicationContext.getBean(ref, TwilioRestClient.class);
            }
        }
        return null;
    }
}

