/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.undertow.spring.boot;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedList;
import org.apache.camel.Component;
import org.apache.camel.component.spring.security.SpringSecurityConfiguration;
import org.apache.camel.component.spring.security.keycloak.KeycloakUsernameSubClaimAdapter;
import org.apache.camel.component.undertow.UndertowComponent;
import org.apache.camel.spi.ComponentCustomizer;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.ComponentConfigurationProperties;
import org.apache.camel.undertow.spring.boot.UndertowSpringSecurityConfiguration;
import org.apache.camel.undertow.spring.boot.providers.AbstractProviderConfiguration;
import org.apache.camel.undertow.spring.boot.providers.KeycloakProviderConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.DelegatingFilterProxyRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.NimbusJwtDecoder;
import org.springframework.security.web.SecurityFilterChain;

@Configuration(proxyBeanMethods=false)
@AutoConfigureAfter(value={CamelAutoConfiguration.class})
@EnableConfigurationProperties(value={ComponentConfigurationProperties.class, UndertowSpringSecurityConfiguration.class})
public class UndertowSpringSecurityCustomizer
implements ComponentCustomizer {
    private AbstractProviderConfiguration provider;
    private ClientRegistration clientRegistration;
    @Autowired
    private UndertowSpringSecurityConfiguration configuration;
    @Autowired
    private DelegatingFilterProxyRegistrationBean delegatingFilterProxyRegistrationBean;

    public void configure(String name, Component target) {
        UndertowComponent uc = (UndertowComponent)target;
        SpringSecurityConfiguration securityConfiguration = () -> this.delegatingFilterProxyRegistrationBean.getFilter();
        uc.setSecurityConfiguration((Object)securityConfiguration);
    }

    public boolean isEnabled(String name, Component target) {
        return target instanceof UndertowComponent;
    }

    public int getOrder() {
        return -1;
    }

    @Bean
    public JwtDecoder jwtDecoderByIssuerUri() {
        String jwkSetUri = this.getClientRegistration().getProviderDetails().getJwkSetUri();
        NimbusJwtDecoder jwtDecoder = NimbusJwtDecoder.withJwkSetUri((String)jwkSetUri).build();
        jwtDecoder.setClaimSetConverter((Converter)new KeycloakUsernameSubClaimAdapter(this.getProvider().getUserNameAttribute()));
        return jwtDecoder;
    }

    @Bean
    public ClientRegistrationRepository clientRegistrationRepository() {
        return new InMemoryClientRegistrationRepository(Collections.singletonList(this.getClientRegistration()));
    }

    @Bean
    public OAuth2AuthorizedClientService authorizedClientService(ClientRegistrationRepository repository) {
        return new InMemoryOAuth2AuthorizedClientService(repository);
    }

    private AbstractProviderConfiguration getProvider() {
        if (this.provider == null) {
            LinkedList<KeycloakProviderConfiguration> definedProviders = new LinkedList<KeycloakProviderConfiguration>();
            if (this.configuration.getKeycloak() != null) {
                definedProviders.add(this.configuration.getKeycloak());
            }
            if (definedProviders.isEmpty()) {
                throw new IllegalArgumentException(String.format("Properties camel.component.undertow.spring.security.provider.* are not defined. Allowed providers are (%s)", (Object[])ProviderType.values()));
            }
            if (definedProviders.size() > 1) {
                throw new IllegalArgumentException(String.format("Two or more providers are defined (%s)", definedProviders));
            }
            this.provider = (AbstractProviderConfiguration)definedProviders.getFirst();
        }
        return this.provider;
    }

    private ClientRegistration getClientRegistration() {
        if (this.clientRegistration == null) {
            try {
                this.clientRegistration = this.getProvider().getClientRegistration();
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Client url is not correct.", e);
            }
        }
        return this.clientRegistration;
    }

    private static enum ProviderType {
        keycloak;

    }

    @EnableWebSecurity
    public class SecurityConfiguration {
        @Bean
        public SecurityFilterChain filterChain(HttpSecurity http) throws Exception {
            ((HttpSecurity)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((HttpSecurity)http.sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS).and()).authorizeHttpRequests().anyRequest()).authenticated().and()).oauth2ResourceServer().jwt().jwtAuthenticationConverter(UndertowSpringSecurityCustomizer.this.getProvider().getJwtAuthenticationConverter());
            return (SecurityFilterChain)http.build();
        }
    }
}

