/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.undertow.spring.boot.providers;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.component.spring.security.keycloak.KeycloakJwtAuthenticationConverter;
import org.apache.camel.undertow.spring.boot.providers.AbstractProviderConfiguration;
import org.springframework.core.convert.converter.Converter;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.jwt.Jwt;

public class KeycloakProviderConfiguration
extends AbstractProviderConfiguration {
    private String url;
    private String realmId;
    private String clientId;
    private String userNameAttribute = "preferred_username";

    @Override
    public AbstractProviderConfiguration.TYPE getType() {
        return AbstractProviderConfiguration.TYPE.keycloak;
    }

    @Override
    public Converter<Jwt, ? extends AbstractAuthenticationToken> getJwtAuthenticationConverter() {
        return new KeycloakJwtAuthenticationConverter();
    }

    @Override
    public ClientRegistration getClientRegistration() throws URISyntaxException {
        URI keycloakUri = new URI(this.getUrl()).resolve("/auth/realms/" + this.getRealmId() + "/protocol/openid-connect");
        return ClientRegistration.withRegistrationId((String)this.getType().name()).clientId(this.getClientId()).authorizationGrantType(AuthorizationGrantType.AUTHORIZATION_CODE).redirectUri("{baseUrl}/login/oauth2/code/{registrationId}").scope(new String[]{"openid", "profile", "email"}).authorizationUri(String.valueOf(keycloakUri) + "/auth").tokenUri(String.valueOf(keycloakUri) + "/token").jwkSetUri(String.valueOf(keycloakUri) + "/certs").userNameAttributeName(this.getUserNameAttribute()).build();
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getRealmId() {
        return this.realmId;
    }

    public void setRealmId(String realmId) {
        this.realmId = realmId;
    }

    @Override
    public String getUserNameAttribute() {
        return this.userNameAttribute;
    }

    public void setUserNameAttribute(String userNameAttribute) {
        this.userNameAttribute = userNameAttribute;
    }
}

