/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.zipkin.starter;

import org.apache.camel.CamelContext;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.zipkin.ZipkinTracer;
import org.apache.camel.zipkin.starter.ZipkinConfigurationProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ZipkinConfigurationProperties.class})
@ConditionalOnProperty(value={"camel.zipkin.enabled"}, matchIfMissing=true)
@Deprecated
public class ZipkinAutoConfiguration {
    @Bean(initMethod="", destroyMethod="")
    @ConditionalOnMissingBean(value={ZipkinTracer.class})
    ZipkinTracer zipkinEventNotifier(CamelContext camelContext, ZipkinConfigurationProperties config) {
        ZipkinTracer zipkin = new ZipkinTracer();
        zipkin.setEndpoint(config.getEndpoint());
        zipkin.setHostName(config.getHostName());
        zipkin.setPort(config.getPort());
        zipkin.setRate(config.getRate());
        if (ObjectHelper.isNotEmpty((String)config.getServiceName())) {
            zipkin.setServiceName(config.getServiceName());
        }
        if (config.getExcludePatterns() != null) {
            zipkin.setExcludePatterns(config.getExcludePatterns());
        }
        if (config.getClientServiceMappings() != null) {
            zipkin.setClientServiceMappings(config.getClientServiceMappings());
        }
        if (config.getServerServiceMappings() != null) {
            zipkin.setServerServiceMappings(config.getServerServiceMappings());
        }
        zipkin.setIncludeMessageBody(config.isIncludeMessageBody());
        zipkin.setIncludeMessageBodyStreams(config.isIncludeMessageBodyStreams());
        zipkin.init(camelContext);
        return zipkin;
    }
}

