/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.springboot.cluster;

import java.util.Optional;
import org.apache.camel.cluster.CamelClusterService;
import org.apache.camel.component.zookeeper.ZooKeeperCuratorConfiguration;
import org.apache.camel.component.zookeeper.cluster.ZooKeeperClusterService;
import org.apache.camel.component.zookeeper.springboot.cluster.ZooKeeperClusterServiceConfiguration;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.cluster.ClusteredRouteControllerAutoConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;

@Configuration
@AutoConfigureBefore(value={ClusteredRouteControllerAutoConfiguration.class, CamelAutoConfiguration.class})
@ConditionalOnProperty(prefix="camel.cluster.zookeeper", name={"enabled"})
@EnableConfigurationProperties(value={ZooKeeperClusterServiceConfiguration.class})
public class ZooKeeperClusterServiceAutoConfiguration {
    @Autowired
    private ZooKeeperClusterServiceConfiguration configuration;

    @Bean(name={"zookeeper-cluster-service"})
    @Scope(value="singleton")
    public CamelClusterService zookeeperClusterService() throws Exception {
        ZooKeeperClusterService service = new ZooKeeperClusterService();
        Optional.ofNullable(this.configuration.getId()).ifPresent(arg_0 -> ((ZooKeeperClusterService)service).setId(arg_0));
        Optional.ofNullable(this.configuration.getOrder()).ifPresent(arg_0 -> ((ZooKeeperClusterService)service).setOrder(arg_0));
        Optional.ofNullable(this.configuration.getAttributes()).ifPresent(arg_0 -> ((ZooKeeperClusterService)service).setAttributes(arg_0));
        Optional.ofNullable(this.configuration.getBasePath()).ifPresent(arg_0 -> ((ZooKeeperClusterService)service).setBasePath(arg_0));
        Optional.ofNullable(this.configuration.getNamespace()).ifPresent(arg_0 -> ((ZooKeeperClusterService)service).setNamespace(arg_0));
        Optional.ofNullable(this.configuration.getAuthInfoList()).ifPresent(arg_0 -> ((ZooKeeperClusterService)service).setAuthInfoList(arg_0));
        Optional.of(this.configuration.getConnectionTimeout()).ifPresent(arg_0 -> ((ZooKeeperClusterService)service).setConnectionTimeout(arg_0));
        Optional.ofNullable(this.configuration.getConnectionTimeoutUnit()).ifPresent(arg_0 -> ((ZooKeeperClusterService)service).setConnectionTimeoutUnit(arg_0));
        Optional.ofNullable(this.configuration.getCuratorFramework()).ifPresent(arg_0 -> ((ZooKeeperClusterService)service).setCuratorFramework(arg_0));
        Optional.of(this.configuration.getMaxCloseWait()).ifPresent(arg_0 -> ((ZooKeeperClusterService)service).setMaxCloseWait(arg_0));
        Optional.ofNullable(this.configuration.getMaxCloseWaitUnit()).ifPresent(arg_0 -> ((ZooKeeperClusterService)service).setMaxCloseWaitUnit(arg_0));
        Optional.ofNullable(this.configuration.getNodes()).ifPresent(arg_0 -> ((ZooKeeperClusterService)service).setNodes(arg_0));
        Optional.of(this.configuration.getReconnectBaseSleepTime()).ifPresent(arg_0 -> ((ZooKeeperClusterService)service).setReconnectBaseSleepTime(arg_0));
        Optional.ofNullable(this.configuration.getReconnectBaseSleepTimeUnit()).ifPresent(arg_0 -> ((ZooKeeperClusterService)service).setReconnectBaseSleepTimeUnit(arg_0));
        Optional.of(this.configuration.getReconnectMaxRetries()).ifPresent(arg_0 -> ((ZooKeeperClusterService)service).setReconnectMaxRetries(arg_0));
        Optional.ofNullable(this.configuration.getRetryPolicy()).ifPresent(arg_0 -> ((ZooKeeperClusterService)service).setRetryPolicy(arg_0));
        Optional.of(this.configuration.getSessionTimeout()).ifPresent(arg_0 -> ((ZooKeeperClusterService)service).setSessionTimeout(arg_0));
        Optional.ofNullable(this.configuration.getSessionTimeoutUnit()).ifPresent(arg_0 -> ((ZooKeeperClusterService)service).setSessionTimeoutUnit(arg_0));
        service.setConfiguration((ZooKeeperCuratorConfiguration)this.configuration);
        return service;
    }
}

