/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.common;

import java.util.Objects;
import org.apache.carbondata.common.annotations.InterfaceAudience;

@InterfaceAudience.Internal
public class Strings {
    public static String mkString(String[] strings, String delimiter) {
        Objects.requireNonNull(strings);
        Objects.requireNonNull(delimiter);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            builder.append(strings[i]);
            if (i == strings.length - 1) continue;
            builder.append(delimiter);
        }
        return builder.toString();
    }

    public static String formatSize(float sizeInBytes) {
        long KB = 1024L;
        long MB = KB << 10;
        long GB = MB << 10;
        long TB = GB << 10;
        if (sizeInBytes < 0.0f) {
            return "NA";
        }
        if (sizeInBytes >= 0.0f && sizeInBytes < (float)KB) {
            return String.format("%sB", Float.valueOf(sizeInBytes));
        }
        if (sizeInBytes >= (float)KB && sizeInBytes < (float)MB) {
            return String.format("%.2fKB", Float.valueOf(sizeInBytes / (float)KB));
        }
        if (sizeInBytes >= (float)MB && sizeInBytes < (float)GB) {
            return String.format("%.2fMB", Float.valueOf(sizeInBytes / (float)MB));
        }
        if (sizeInBytes >= (float)GB && sizeInBytes < (float)TB) {
            return String.format("%.2fGB", Float.valueOf(sizeInBytes / (float)GB));
        }
        return String.format("%.2fTB", Float.valueOf(sizeInBytes / (float)TB));
    }
}

