/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.format;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.format.ColumnSchema;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileHeader
implements TBase<FileHeader, _Fields>,
Serializable,
Cloneable,
Comparable<FileHeader> {
    private static final TStruct STRUCT_DESC = new TStruct("FileHeader");
    private static final TField VERSION_FIELD_DESC = new TField("version", 8, 1);
    private static final TField COLUMN_SCHEMA_FIELD_DESC = new TField("column_schema", 15, 2);
    private static final TField IS_FOOTER_PRESENT_FIELD_DESC = new TField("is_footer_present", 2, 3);
    private static final TField TIME_STAMP_FIELD_DESC = new TField("time_stamp", 10, 4);
    private static final TField IS_SPLITABLE_FIELD_DESC = new TField("is_splitable", 2, 5);
    private static final TField SYNC_MARKER_FIELD_DESC = new TField("sync_marker", 11, 6);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public int version;
    public List<ColumnSchema> column_schema;
    public boolean is_footer_present;
    public long time_stamp;
    public boolean is_splitable;
    public ByteBuffer sync_marker;
    private static final int __VERSION_ISSET_ID = 0;
    private static final int __IS_FOOTER_PRESENT_ISSET_ID = 1;
    private static final int __TIME_STAMP_ISSET_ID = 2;
    private static final int __IS_SPLITABLE_ISSET_ID = 3;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public FileHeader() {
    }

    public FileHeader(int version, List<ColumnSchema> column_schema) {
        this();
        this.version = version;
        this.setVersionIsSet(true);
        this.column_schema = column_schema;
    }

    public FileHeader(FileHeader other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.version = other.version;
        if (other.isSetColumn_schema()) {
            ArrayList<ColumnSchema> __this__column_schema = new ArrayList<ColumnSchema>(other.column_schema.size());
            for (ColumnSchema other_element : other.column_schema) {
                __this__column_schema.add(new ColumnSchema(other_element));
            }
            this.column_schema = __this__column_schema;
        }
        this.is_footer_present = other.is_footer_present;
        this.time_stamp = other.time_stamp;
        this.is_splitable = other.is_splitable;
        if (other.isSetSync_marker()) {
            this.sync_marker = TBaseHelper.copyBinary((ByteBuffer)other.sync_marker);
        }
    }

    public FileHeader deepCopy() {
        return new FileHeader(this);
    }

    public void clear() {
        this.setVersionIsSet(false);
        this.version = 0;
        this.column_schema = null;
        this.setIs_footer_presentIsSet(false);
        this.is_footer_present = false;
        this.setTime_stampIsSet(false);
        this.time_stamp = 0L;
        this.setIs_splitableIsSet(false);
        this.is_splitable = false;
        this.sync_marker = null;
    }

    public int getVersion() {
        return this.version;
    }

    public FileHeader setVersion(int version) {
        this.version = version;
        this.setVersionIsSet(true);
        return this;
    }

    public void unsetVersion() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetVersion() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setVersionIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public int getColumn_schemaSize() {
        return this.column_schema == null ? 0 : this.column_schema.size();
    }

    public Iterator<ColumnSchema> getColumn_schemaIterator() {
        return this.column_schema == null ? null : this.column_schema.iterator();
    }

    public void addToColumn_schema(ColumnSchema elem) {
        if (this.column_schema == null) {
            this.column_schema = new ArrayList<ColumnSchema>();
        }
        this.column_schema.add(elem);
    }

    public List<ColumnSchema> getColumn_schema() {
        return this.column_schema;
    }

    public FileHeader setColumn_schema(List<ColumnSchema> column_schema) {
        this.column_schema = column_schema;
        return this;
    }

    public void unsetColumn_schema() {
        this.column_schema = null;
    }

    public boolean isSetColumn_schema() {
        return this.column_schema != null;
    }

    public void setColumn_schemaIsSet(boolean value) {
        if (!value) {
            this.column_schema = null;
        }
    }

    public boolean isIs_footer_present() {
        return this.is_footer_present;
    }

    public FileHeader setIs_footer_present(boolean is_footer_present) {
        this.is_footer_present = is_footer_present;
        this.setIs_footer_presentIsSet(true);
        return this;
    }

    public void unsetIs_footer_present() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetIs_footer_present() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setIs_footer_presentIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public long getTime_stamp() {
        return this.time_stamp;
    }

    public FileHeader setTime_stamp(long time_stamp) {
        this.time_stamp = time_stamp;
        this.setTime_stampIsSet(true);
        return this;
    }

    public void unsetTime_stamp() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)2);
    }

    public boolean isSetTime_stamp() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)2);
    }

    public void setTime_stampIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public boolean isIs_splitable() {
        return this.is_splitable;
    }

    public FileHeader setIs_splitable(boolean is_splitable) {
        this.is_splitable = is_splitable;
        this.setIs_splitableIsSet(true);
        return this;
    }

    public void unsetIs_splitable() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)3);
    }

    public boolean isSetIs_splitable() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)3);
    }

    public void setIs_splitableIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public byte[] getSync_marker() {
        this.setSync_marker(TBaseHelper.rightSize((ByteBuffer)this.sync_marker));
        return this.sync_marker == null ? null : this.sync_marker.array();
    }

    public ByteBuffer bufferForSync_marker() {
        return TBaseHelper.copyBinary((ByteBuffer)this.sync_marker);
    }

    public FileHeader setSync_marker(byte[] sync_marker) {
        this.sync_marker = sync_marker == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(sync_marker, sync_marker.length));
        return this;
    }

    public FileHeader setSync_marker(ByteBuffer sync_marker) {
        this.sync_marker = TBaseHelper.copyBinary((ByteBuffer)sync_marker);
        return this;
    }

    public void unsetSync_marker() {
        this.sync_marker = null;
    }

    public boolean isSetSync_marker() {
        return this.sync_marker != null;
    }

    public void setSync_markerIsSet(boolean value) {
        if (!value) {
            this.sync_marker = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case VERSION: {
                if (value == null) {
                    this.unsetVersion();
                    break;
                }
                this.setVersion((Integer)value);
                break;
            }
            case COLUMN_SCHEMA: {
                if (value == null) {
                    this.unsetColumn_schema();
                    break;
                }
                this.setColumn_schema((List)value);
                break;
            }
            case IS_FOOTER_PRESENT: {
                if (value == null) {
                    this.unsetIs_footer_present();
                    break;
                }
                this.setIs_footer_present((Boolean)value);
                break;
            }
            case TIME_STAMP: {
                if (value == null) {
                    this.unsetTime_stamp();
                    break;
                }
                this.setTime_stamp((Long)value);
                break;
            }
            case IS_SPLITABLE: {
                if (value == null) {
                    this.unsetIs_splitable();
                    break;
                }
                this.setIs_splitable((Boolean)value);
                break;
            }
            case SYNC_MARKER: {
                if (value == null) {
                    this.unsetSync_marker();
                    break;
                }
                this.setSync_marker((ByteBuffer)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case VERSION: {
                return this.getVersion();
            }
            case COLUMN_SCHEMA: {
                return this.getColumn_schema();
            }
            case IS_FOOTER_PRESENT: {
                return this.isIs_footer_present();
            }
            case TIME_STAMP: {
                return this.getTime_stamp();
            }
            case IS_SPLITABLE: {
                return this.isIs_splitable();
            }
            case SYNC_MARKER: {
                return this.getSync_marker();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case VERSION: {
                return this.isSetVersion();
            }
            case COLUMN_SCHEMA: {
                return this.isSetColumn_schema();
            }
            case IS_FOOTER_PRESENT: {
                return this.isSetIs_footer_present();
            }
            case TIME_STAMP: {
                return this.isSetTime_stamp();
            }
            case IS_SPLITABLE: {
                return this.isSetIs_splitable();
            }
            case SYNC_MARKER: {
                return this.isSetSync_marker();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof FileHeader) {
            return this.equals((FileHeader)that);
        }
        return false;
    }

    public boolean equals(FileHeader that) {
        if (that == null) {
            return false;
        }
        boolean this_present_version = true;
        boolean that_present_version = true;
        if (this_present_version || that_present_version) {
            if (!this_present_version || !that_present_version) {
                return false;
            }
            if (this.version != that.version) {
                return false;
            }
        }
        boolean this_present_column_schema = this.isSetColumn_schema();
        boolean that_present_column_schema = that.isSetColumn_schema();
        if (this_present_column_schema || that_present_column_schema) {
            if (!this_present_column_schema || !that_present_column_schema) {
                return false;
            }
            if (!this.column_schema.equals(that.column_schema)) {
                return false;
            }
        }
        boolean this_present_is_footer_present = this.isSetIs_footer_present();
        boolean that_present_is_footer_present = that.isSetIs_footer_present();
        if (this_present_is_footer_present || that_present_is_footer_present) {
            if (!this_present_is_footer_present || !that_present_is_footer_present) {
                return false;
            }
            if (this.is_footer_present != that.is_footer_present) {
                return false;
            }
        }
        boolean this_present_time_stamp = this.isSetTime_stamp();
        boolean that_present_time_stamp = that.isSetTime_stamp();
        if (this_present_time_stamp || that_present_time_stamp) {
            if (!this_present_time_stamp || !that_present_time_stamp) {
                return false;
            }
            if (this.time_stamp != that.time_stamp) {
                return false;
            }
        }
        boolean this_present_is_splitable = this.isSetIs_splitable();
        boolean that_present_is_splitable = that.isSetIs_splitable();
        if (this_present_is_splitable || that_present_is_splitable) {
            if (!this_present_is_splitable || !that_present_is_splitable) {
                return false;
            }
            if (this.is_splitable != that.is_splitable) {
                return false;
            }
        }
        boolean this_present_sync_marker = this.isSetSync_marker();
        boolean that_present_sync_marker = that.isSetSync_marker();
        if (this_present_sync_marker || that_present_sync_marker) {
            if (!this_present_sync_marker || !that_present_sync_marker) {
                return false;
            }
            if (!this.sync_marker.equals(that.sync_marker)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_version = true;
        list.add(present_version);
        if (present_version) {
            list.add(this.version);
        }
        boolean present_column_schema = this.isSetColumn_schema();
        list.add(present_column_schema);
        if (present_column_schema) {
            list.add(this.column_schema);
        }
        boolean present_is_footer_present = this.isSetIs_footer_present();
        list.add(present_is_footer_present);
        if (present_is_footer_present) {
            list.add(this.is_footer_present);
        }
        boolean present_time_stamp = this.isSetTime_stamp();
        list.add(present_time_stamp);
        if (present_time_stamp) {
            list.add(this.time_stamp);
        }
        boolean present_is_splitable = this.isSetIs_splitable();
        list.add(present_is_splitable);
        if (present_is_splitable) {
            list.add(this.is_splitable);
        }
        boolean present_sync_marker = this.isSetSync_marker();
        list.add(present_sync_marker);
        if (present_sync_marker) {
            list.add(this.sync_marker);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(FileHeader other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetVersion()).compareTo(other.isSetVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetVersion() && (lastComparison = TBaseHelper.compareTo((int)this.version, (int)other.version)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumn_schema()).compareTo(other.isSetColumn_schema());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumn_schema() && (lastComparison = TBaseHelper.compareTo(this.column_schema, other.column_schema)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIs_footer_present()).compareTo(other.isSetIs_footer_present());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIs_footer_present() && (lastComparison = TBaseHelper.compareTo((boolean)this.is_footer_present, (boolean)other.is_footer_present)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTime_stamp()).compareTo(other.isSetTime_stamp());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTime_stamp() && (lastComparison = TBaseHelper.compareTo((long)this.time_stamp, (long)other.time_stamp)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetIs_splitable()).compareTo(other.isSetIs_splitable());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetIs_splitable() && (lastComparison = TBaseHelper.compareTo((boolean)this.is_splitable, (boolean)other.is_splitable)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSync_marker()).compareTo(other.isSetSync_marker());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSync_marker() && (lastComparison = TBaseHelper.compareTo((Comparable)this.sync_marker, (Comparable)other.sync_marker)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FileHeader(");
        boolean first = true;
        sb.append("version:");
        sb.append(this.version);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("column_schema:");
        if (this.column_schema == null) {
            sb.append("null");
        } else {
            sb.append(this.column_schema);
        }
        first = false;
        if (this.isSetIs_footer_present()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("is_footer_present:");
            sb.append(this.is_footer_present);
            first = false;
        }
        if (this.isSetTime_stamp()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("time_stamp:");
            sb.append(this.time_stamp);
            first = false;
        }
        if (this.isSetIs_splitable()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("is_splitable:");
            sb.append(this.is_splitable);
            first = false;
        }
        if (this.isSetSync_marker()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("sync_marker:");
            if (this.sync_marker == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString((ByteBuffer)this.sync_marker, (StringBuilder)sb);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.column_schema == null) {
            throw new TProtocolException("Required field 'column_schema' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new FileHeaderStandardSchemeFactory());
        schemes.put(TupleScheme.class, new FileHeaderTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.IS_FOOTER_PRESENT, _Fields.TIME_STAMP, _Fields.IS_SPLITABLE, _Fields.SYNC_MARKER};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.VERSION, new FieldMetaData("version", 1, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.COLUMN_SCHEMA, new FieldMetaData("column_schema", 1, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, ColumnSchema.class))));
        tmpMap.put(_Fields.IS_FOOTER_PRESENT, new FieldMetaData("is_footer_present", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.TIME_STAMP, new FieldMetaData("time_stamp", 2, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.IS_SPLITABLE, new FieldMetaData("is_splitable", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.SYNC_MARKER, new FieldMetaData("sync_marker", 2, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(FileHeader.class, metaDataMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileHeaderTupleScheme
    extends TupleScheme<FileHeader> {
        private FileHeaderTupleScheme() {
        }

        public void write(TProtocol prot, FileHeader struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.version);
            oprot.writeI32(struct.column_schema.size());
            for (ColumnSchema _iter180 : struct.column_schema) {
                _iter180.write((TProtocol)oprot);
            }
            BitSet optionals = new BitSet();
            if (struct.isSetIs_footer_present()) {
                optionals.set(0);
            }
            if (struct.isSetTime_stamp()) {
                optionals.set(1);
            }
            if (struct.isSetIs_splitable()) {
                optionals.set(2);
            }
            if (struct.isSetSync_marker()) {
                optionals.set(3);
            }
            oprot.writeBitSet(optionals, 4);
            if (struct.isSetIs_footer_present()) {
                oprot.writeBool(struct.is_footer_present);
            }
            if (struct.isSetTime_stamp()) {
                oprot.writeI64(struct.time_stamp);
            }
            if (struct.isSetIs_splitable()) {
                oprot.writeBool(struct.is_splitable);
            }
            if (struct.isSetSync_marker()) {
                oprot.writeBinary(struct.sync_marker);
            }
        }

        public void read(TProtocol prot, FileHeader struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.version = iprot.readI32();
            struct.setVersionIsSet(true);
            TList _list181 = new TList(12, iprot.readI32());
            struct.column_schema = new ArrayList<ColumnSchema>(_list181.size);
            for (int _i183 = 0; _i183 < _list181.size; ++_i183) {
                ColumnSchema _elem182 = new ColumnSchema();
                _elem182.read((TProtocol)iprot);
                struct.column_schema.add(_elem182);
            }
            struct.setColumn_schemaIsSet(true);
            BitSet incoming = iprot.readBitSet(4);
            if (incoming.get(0)) {
                struct.is_footer_present = iprot.readBool();
                struct.setIs_footer_presentIsSet(true);
            }
            if (incoming.get(1)) {
                struct.time_stamp = iprot.readI64();
                struct.setTime_stampIsSet(true);
            }
            if (incoming.get(2)) {
                struct.is_splitable = iprot.readBool();
                struct.setIs_splitableIsSet(true);
            }
            if (incoming.get(3)) {
                struct.sync_marker = iprot.readBinary();
                struct.setSync_markerIsSet(true);
            }
        }
    }

    private static class FileHeaderTupleSchemeFactory
    implements SchemeFactory {
        private FileHeaderTupleSchemeFactory() {
        }

        public FileHeaderTupleScheme getScheme() {
            return new FileHeaderTupleScheme();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileHeaderStandardScheme
    extends StandardScheme<FileHeader> {
        private FileHeaderStandardScheme() {
        }

        public void read(TProtocol iprot, FileHeader struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 8) {
                            struct.version = iprot.readI32();
                            struct.setVersionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 15) {
                            TList _list176 = iprot.readListBegin();
                            struct.column_schema = new ArrayList<ColumnSchema>(_list176.size);
                            for (int _i178 = 0; _i178 < _list176.size; ++_i178) {
                                ColumnSchema _elem177 = new ColumnSchema();
                                _elem177.read(iprot);
                                struct.column_schema.add(_elem177);
                            }
                            iprot.readListEnd();
                            struct.setColumn_schemaIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 2) {
                            struct.is_footer_present = iprot.readBool();
                            struct.setIs_footer_presentIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 10) {
                            struct.time_stamp = iprot.readI64();
                            struct.setTime_stampIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 2) {
                            struct.is_splitable = iprot.readBool();
                            struct.setIs_splitableIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 11) {
                            struct.sync_marker = iprot.readBinary();
                            struct.setSync_markerIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetVersion()) {
                throw new TProtocolException("Required field 'version' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, FileHeader struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(VERSION_FIELD_DESC);
            oprot.writeI32(struct.version);
            oprot.writeFieldEnd();
            if (struct.column_schema != null) {
                oprot.writeFieldBegin(COLUMN_SCHEMA_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.column_schema.size()));
                for (ColumnSchema _iter179 : struct.column_schema) {
                    _iter179.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetIs_footer_present()) {
                oprot.writeFieldBegin(IS_FOOTER_PRESENT_FIELD_DESC);
                oprot.writeBool(struct.is_footer_present);
                oprot.writeFieldEnd();
            }
            if (struct.isSetTime_stamp()) {
                oprot.writeFieldBegin(TIME_STAMP_FIELD_DESC);
                oprot.writeI64(struct.time_stamp);
                oprot.writeFieldEnd();
            }
            if (struct.isSetIs_splitable()) {
                oprot.writeFieldBegin(IS_SPLITABLE_FIELD_DESC);
                oprot.writeBool(struct.is_splitable);
                oprot.writeFieldEnd();
            }
            if (struct.sync_marker != null && struct.isSetSync_marker()) {
                oprot.writeFieldBegin(SYNC_MARKER_FIELD_DESC);
                oprot.writeBinary(struct.sync_marker);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class FileHeaderStandardSchemeFactory
    implements SchemeFactory {
        private FileHeaderStandardSchemeFactory() {
        }

        public FileHeaderStandardScheme getScheme() {
            return new FileHeaderStandardScheme();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum _Fields implements TFieldIdEnum
    {
        VERSION(1, "version"),
        COLUMN_SCHEMA(2, "column_schema"),
        IS_FOOTER_PRESENT(3, "is_footer_present"),
        TIME_STAMP(4, "time_stamp"),
        IS_SPLITABLE(5, "is_splitable"),
        SYNC_MARKER(6, "sync_marker");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return VERSION;
                }
                case 2: {
                    return COLUMN_SCHEMA;
                }
                case 3: {
                    return IS_FOOTER_PRESENT;
                }
                case 4: {
                    return TIME_STAMP;
                }
                case 5: {
                    return IS_SPLITABLE;
                }
                case 6: {
                    return SYNC_MARKER;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

