/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.format;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.apache.carbondata.format.LocalDictionaryChunkMeta;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalDictionaryChunk
implements TBase<LocalDictionaryChunk, _Fields>,
Serializable,
Cloneable,
Comparable<LocalDictionaryChunk> {
    private static final TStruct STRUCT_DESC = new TStruct("LocalDictionaryChunk");
    private static final TField DICTIONARY_META_FIELD_DESC = new TField("dictionary_meta", 12, 1);
    private static final TField DICTIONARY_DATA_FIELD_DESC = new TField("dictionary_data", 11, 2);
    private static final TField DICTIONARY_VALUES_FIELD_DESC = new TField("dictionary_values", 11, 3);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public LocalDictionaryChunkMeta dictionary_meta;
    public ByteBuffer dictionary_data;
    public ByteBuffer dictionary_values;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public LocalDictionaryChunk() {
    }

    public LocalDictionaryChunk(LocalDictionaryChunkMeta dictionary_meta, ByteBuffer dictionary_data, ByteBuffer dictionary_values) {
        this();
        this.dictionary_meta = dictionary_meta;
        this.dictionary_data = TBaseHelper.copyBinary((ByteBuffer)dictionary_data);
        this.dictionary_values = TBaseHelper.copyBinary((ByteBuffer)dictionary_values);
    }

    public LocalDictionaryChunk(LocalDictionaryChunk other) {
        if (other.isSetDictionary_meta()) {
            this.dictionary_meta = other.dictionary_meta;
        }
        if (other.isSetDictionary_data()) {
            this.dictionary_data = TBaseHelper.copyBinary((ByteBuffer)other.dictionary_data);
        }
        if (other.isSetDictionary_values()) {
            this.dictionary_values = TBaseHelper.copyBinary((ByteBuffer)other.dictionary_values);
        }
    }

    public LocalDictionaryChunk deepCopy() {
        return new LocalDictionaryChunk(this);
    }

    public void clear() {
        this.dictionary_meta = null;
        this.dictionary_data = null;
        this.dictionary_values = null;
    }

    public LocalDictionaryChunkMeta getDictionary_meta() {
        return this.dictionary_meta;
    }

    public LocalDictionaryChunk setDictionary_meta(LocalDictionaryChunkMeta dictionary_meta) {
        this.dictionary_meta = dictionary_meta;
        return this;
    }

    public void unsetDictionary_meta() {
        this.dictionary_meta = null;
    }

    public boolean isSetDictionary_meta() {
        return this.dictionary_meta != null;
    }

    public void setDictionary_metaIsSet(boolean value) {
        if (!value) {
            this.dictionary_meta = null;
        }
    }

    public byte[] getDictionary_data() {
        this.setDictionary_data(TBaseHelper.rightSize((ByteBuffer)this.dictionary_data));
        return this.dictionary_data == null ? null : this.dictionary_data.array();
    }

    public ByteBuffer bufferForDictionary_data() {
        return TBaseHelper.copyBinary((ByteBuffer)this.dictionary_data);
    }

    public LocalDictionaryChunk setDictionary_data(byte[] dictionary_data) {
        this.dictionary_data = dictionary_data == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(dictionary_data, dictionary_data.length));
        return this;
    }

    public LocalDictionaryChunk setDictionary_data(ByteBuffer dictionary_data) {
        this.dictionary_data = TBaseHelper.copyBinary((ByteBuffer)dictionary_data);
        return this;
    }

    public void unsetDictionary_data() {
        this.dictionary_data = null;
    }

    public boolean isSetDictionary_data() {
        return this.dictionary_data != null;
    }

    public void setDictionary_dataIsSet(boolean value) {
        if (!value) {
            this.dictionary_data = null;
        }
    }

    public byte[] getDictionary_values() {
        this.setDictionary_values(TBaseHelper.rightSize((ByteBuffer)this.dictionary_values));
        return this.dictionary_values == null ? null : this.dictionary_values.array();
    }

    public ByteBuffer bufferForDictionary_values() {
        return TBaseHelper.copyBinary((ByteBuffer)this.dictionary_values);
    }

    public LocalDictionaryChunk setDictionary_values(byte[] dictionary_values) {
        this.dictionary_values = dictionary_values == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(dictionary_values, dictionary_values.length));
        return this;
    }

    public LocalDictionaryChunk setDictionary_values(ByteBuffer dictionary_values) {
        this.dictionary_values = TBaseHelper.copyBinary((ByteBuffer)dictionary_values);
        return this;
    }

    public void unsetDictionary_values() {
        this.dictionary_values = null;
    }

    public boolean isSetDictionary_values() {
        return this.dictionary_values != null;
    }

    public void setDictionary_valuesIsSet(boolean value) {
        if (!value) {
            this.dictionary_values = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case DICTIONARY_META: {
                if (value == null) {
                    this.unsetDictionary_meta();
                    break;
                }
                this.setDictionary_meta((LocalDictionaryChunkMeta)value);
                break;
            }
            case DICTIONARY_DATA: {
                if (value == null) {
                    this.unsetDictionary_data();
                    break;
                }
                this.setDictionary_data((ByteBuffer)value);
                break;
            }
            case DICTIONARY_VALUES: {
                if (value == null) {
                    this.unsetDictionary_values();
                    break;
                }
                this.setDictionary_values((ByteBuffer)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case DICTIONARY_META: {
                return this.getDictionary_meta();
            }
            case DICTIONARY_DATA: {
                return this.getDictionary_data();
            }
            case DICTIONARY_VALUES: {
                return this.getDictionary_values();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case DICTIONARY_META: {
                return this.isSetDictionary_meta();
            }
            case DICTIONARY_DATA: {
                return this.isSetDictionary_data();
            }
            case DICTIONARY_VALUES: {
                return this.isSetDictionary_values();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof LocalDictionaryChunk) {
            return this.equals((LocalDictionaryChunk)that);
        }
        return false;
    }

    public boolean equals(LocalDictionaryChunk that) {
        if (that == null) {
            return false;
        }
        boolean this_present_dictionary_meta = this.isSetDictionary_meta();
        boolean that_present_dictionary_meta = that.isSetDictionary_meta();
        if (this_present_dictionary_meta || that_present_dictionary_meta) {
            if (!this_present_dictionary_meta || !that_present_dictionary_meta) {
                return false;
            }
            if (!this.dictionary_meta.equals(that.dictionary_meta)) {
                return false;
            }
        }
        boolean this_present_dictionary_data = this.isSetDictionary_data();
        boolean that_present_dictionary_data = that.isSetDictionary_data();
        if (this_present_dictionary_data || that_present_dictionary_data) {
            if (!this_present_dictionary_data || !that_present_dictionary_data) {
                return false;
            }
            if (!this.dictionary_data.equals(that.dictionary_data)) {
                return false;
            }
        }
        boolean this_present_dictionary_values = this.isSetDictionary_values();
        boolean that_present_dictionary_values = that.isSetDictionary_values();
        if (this_present_dictionary_values || that_present_dictionary_values) {
            if (!this_present_dictionary_values || !that_present_dictionary_values) {
                return false;
            }
            if (!this.dictionary_values.equals(that.dictionary_values)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Comparable<Boolean>> list = new ArrayList<Comparable<Boolean>>();
        boolean present_dictionary_meta = this.isSetDictionary_meta();
        list.add(Boolean.valueOf(present_dictionary_meta));
        if (present_dictionary_meta) {
            list.add(this.dictionary_meta);
        }
        boolean present_dictionary_data = this.isSetDictionary_data();
        list.add(Boolean.valueOf(present_dictionary_data));
        if (present_dictionary_data) {
            list.add(this.dictionary_data);
        }
        boolean present_dictionary_values = this.isSetDictionary_values();
        list.add(Boolean.valueOf(present_dictionary_values));
        if (present_dictionary_values) {
            list.add(this.dictionary_values);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(LocalDictionaryChunk other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetDictionary_meta()).compareTo(other.isSetDictionary_meta());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDictionary_meta() && (lastComparison = TBaseHelper.compareTo((Comparable)this.dictionary_meta, (Comparable)other.dictionary_meta)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDictionary_data()).compareTo(other.isSetDictionary_data());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDictionary_data() && (lastComparison = TBaseHelper.compareTo((Comparable)this.dictionary_data, (Comparable)other.dictionary_data)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDictionary_values()).compareTo(other.isSetDictionary_values());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDictionary_values() && (lastComparison = TBaseHelper.compareTo((Comparable)this.dictionary_values, (Comparable)other.dictionary_values)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("LocalDictionaryChunk(");
        boolean first = true;
        sb.append("dictionary_meta:");
        if (this.dictionary_meta == null) {
            sb.append("null");
        } else {
            sb.append(this.dictionary_meta);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("dictionary_data:");
        if (this.dictionary_data == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.dictionary_data, (StringBuilder)sb);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("dictionary_values:");
        if (this.dictionary_values == null) {
            sb.append("null");
        } else {
            TBaseHelper.toString((ByteBuffer)this.dictionary_values, (StringBuilder)sb);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.dictionary_meta == null) {
            throw new TProtocolException("Required field 'dictionary_meta' was not present! Struct: " + this.toString());
        }
        if (this.dictionary_data == null) {
            throw new TProtocolException("Required field 'dictionary_data' was not present! Struct: " + this.toString());
        }
        if (this.dictionary_values == null) {
            throw new TProtocolException("Required field 'dictionary_values' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new LocalDictionaryChunkStandardSchemeFactory());
        schemes.put(TupleScheme.class, new LocalDictionaryChunkTupleSchemeFactory());
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.DICTIONARY_META, new FieldMetaData("dictionary_meta", 1, new FieldValueMetaData(12, "LocalDictionaryChunkMeta")));
        tmpMap.put(_Fields.DICTIONARY_DATA, new FieldMetaData("dictionary_data", 1, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.DICTIONARY_VALUES, new FieldMetaData("dictionary_values", 1, new FieldValueMetaData(11, true)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(LocalDictionaryChunk.class, metaDataMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalDictionaryChunkTupleScheme
    extends TupleScheme<LocalDictionaryChunk> {
        private LocalDictionaryChunkTupleScheme() {
        }

        public void write(TProtocol prot, LocalDictionaryChunk struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            struct.dictionary_meta.write((TProtocol)oprot);
            oprot.writeBinary(struct.dictionary_data);
            oprot.writeBinary(struct.dictionary_values);
        }

        public void read(TProtocol prot, LocalDictionaryChunk struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.dictionary_meta = new LocalDictionaryChunkMeta();
            struct.dictionary_meta.read((TProtocol)iprot);
            struct.setDictionary_metaIsSet(true);
            struct.dictionary_data = iprot.readBinary();
            struct.setDictionary_dataIsSet(true);
            struct.dictionary_values = iprot.readBinary();
            struct.setDictionary_valuesIsSet(true);
        }
    }

    private static class LocalDictionaryChunkTupleSchemeFactory
    implements SchemeFactory {
        private LocalDictionaryChunkTupleSchemeFactory() {
        }

        public LocalDictionaryChunkTupleScheme getScheme() {
            return new LocalDictionaryChunkTupleScheme();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalDictionaryChunkStandardScheme
    extends StandardScheme<LocalDictionaryChunk> {
        private LocalDictionaryChunkStandardScheme() {
        }

        public void read(TProtocol iprot, LocalDictionaryChunk struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 12) {
                            struct.dictionary_meta = new LocalDictionaryChunkMeta();
                            struct.dictionary_meta.read(iprot);
                            struct.setDictionary_metaIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.dictionary_data = iprot.readBinary();
                            struct.setDictionary_dataIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.dictionary_values = iprot.readBinary();
                            struct.setDictionary_valuesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            struct.validate();
        }

        public void write(TProtocol oprot, LocalDictionaryChunk struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.dictionary_meta != null) {
                oprot.writeFieldBegin(DICTIONARY_META_FIELD_DESC);
                struct.dictionary_meta.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.dictionary_data != null) {
                oprot.writeFieldBegin(DICTIONARY_DATA_FIELD_DESC);
                oprot.writeBinary(struct.dictionary_data);
                oprot.writeFieldEnd();
            }
            if (struct.dictionary_values != null) {
                oprot.writeFieldBegin(DICTIONARY_VALUES_FIELD_DESC);
                oprot.writeBinary(struct.dictionary_values);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class LocalDictionaryChunkStandardSchemeFactory
    implements SchemeFactory {
        private LocalDictionaryChunkStandardSchemeFactory() {
        }

        public LocalDictionaryChunkStandardScheme getScheme() {
            return new LocalDictionaryChunkStandardScheme();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum _Fields implements TFieldIdEnum
    {
        DICTIONARY_META(1, "dictionary_meta"),
        DICTIONARY_DATA(2, "dictionary_data"),
        DICTIONARY_VALUES(3, "dictionary_values");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return DICTIONARY_META;
                }
                case 2: {
                    return DICTIONARY_DATA;
                }
                case 3: {
                    return DICTIONARY_VALUES;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

