/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.format;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.format.DataType;
import org.apache.carbondata.format.Encoding;
import org.apache.carbondata.format.ParentColumnTableRelation;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.MapMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnSchema
implements TBase<ColumnSchema, _Fields>,
Serializable,
Cloneable,
Comparable<ColumnSchema> {
    private static final TStruct STRUCT_DESC = new TStruct("ColumnSchema");
    private static final TField DATA_TYPE_FIELD_DESC = new TField("data_type", 8, 1);
    private static final TField COLUMN_NAME_FIELD_DESC = new TField("column_name", 11, 2);
    private static final TField COLUMN_ID_FIELD_DESC = new TField("column_id", 11, 3);
    private static final TField COLUMNAR_FIELD_DESC = new TField("columnar", 2, 4);
    private static final TField ENCODERS_FIELD_DESC = new TField("encoders", 15, 5);
    private static final TField DIMENSION_FIELD_DESC = new TField("dimension", 2, 6);
    private static final TField COLUMN_GROUP_ID_FIELD_DESC = new TField("column_group_id", 8, 7);
    private static final TField SCALE_FIELD_DESC = new TField("scale", 8, 8);
    private static final TField PRECISION_FIELD_DESC = new TField("precision", 8, 9);
    private static final TField NUM_CHILD_FIELD_DESC = new TField("num_child", 8, 10);
    private static final TField AGGREGATE_FUNCTION_FIELD_DESC = new TField("aggregate_function", 11, 11);
    private static final TField DEFAULT_VALUE_FIELD_DESC = new TField("default_value", 11, 12);
    private static final TField COLUMN_PROPERTIES_FIELD_DESC = new TField("columnProperties", 13, 13);
    private static final TField INVISIBLE_FIELD_DESC = new TField("invisible", 2, 14);
    private static final TField COLUMN_REFERENCE_ID_FIELD_DESC = new TField("columnReferenceId", 11, 15);
    private static final TField SCHEMA_ORDINAL_FIELD_DESC = new TField("schemaOrdinal", 8, 16);
    private static final TField PARENT_COLUMN_TABLE_RELATIONS_FIELD_DESC = new TField("parentColumnTableRelations", 15, 17);
    private static final TField SPATIAL_COLUMN_FIELD_DESC = new TField("spatialColumn", 2, 18);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public DataType data_type;
    public String column_name;
    public String column_id;
    public boolean columnar;
    public List<Encoding> encoders;
    public boolean dimension;
    public int column_group_id;
    public int scale;
    public int precision;
    public int num_child;
    public String aggregate_function;
    public ByteBuffer default_value;
    public Map<String, String> columnProperties;
    public boolean invisible;
    public String columnReferenceId;
    public int schemaOrdinal;
    public List<ParentColumnTableRelation> parentColumnTableRelations;
    public boolean spatialColumn;
    private static final int __COLUMNAR_ISSET_ID = 0;
    private static final int __DIMENSION_ISSET_ID = 1;
    private static final int __COLUMN_GROUP_ID_ISSET_ID = 2;
    private static final int __SCALE_ISSET_ID = 3;
    private static final int __PRECISION_ISSET_ID = 4;
    private static final int __NUM_CHILD_ISSET_ID = 5;
    private static final int __INVISIBLE_ISSET_ID = 6;
    private static final int __SCHEMAORDINAL_ISSET_ID = 7;
    private static final int __SPATIALCOLUMN_ISSET_ID = 8;
    private short __isset_bitfield = 0;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public ColumnSchema() {
    }

    public ColumnSchema(DataType data_type, String column_name, String column_id, boolean columnar, List<Encoding> encoders, boolean dimension) {
        this();
        this.data_type = data_type;
        this.column_name = column_name;
        this.column_id = column_id;
        this.columnar = columnar;
        this.setColumnarIsSet(true);
        this.encoders = encoders;
        this.dimension = dimension;
        this.setDimensionIsSet(true);
    }

    public ColumnSchema(ColumnSchema other) {
        this.__isset_bitfield = other.__isset_bitfield;
        if (other.isSetData_type()) {
            this.data_type = other.data_type;
        }
        if (other.isSetColumn_name()) {
            this.column_name = other.column_name;
        }
        if (other.isSetColumn_id()) {
            this.column_id = other.column_id;
        }
        this.columnar = other.columnar;
        if (other.isSetEncoders()) {
            ArrayList<Encoding> __this__encoders = new ArrayList<Encoding>(other.encoders.size());
            for (Encoding encoding : other.encoders) {
                __this__encoders.add(encoding);
            }
            this.encoders = __this__encoders;
        }
        this.dimension = other.dimension;
        this.column_group_id = other.column_group_id;
        this.scale = other.scale;
        this.precision = other.precision;
        this.num_child = other.num_child;
        if (other.isSetAggregate_function()) {
            this.aggregate_function = other.aggregate_function;
        }
        if (other.isSetDefault_value()) {
            this.default_value = TBaseHelper.copyBinary((ByteBuffer)other.default_value);
        }
        if (other.isSetColumnProperties()) {
            HashMap<String, String> __this__columnProperties = new HashMap<String, String>(other.columnProperties);
            this.columnProperties = __this__columnProperties;
        }
        this.invisible = other.invisible;
        if (other.isSetColumnReferenceId()) {
            this.columnReferenceId = other.columnReferenceId;
        }
        this.schemaOrdinal = other.schemaOrdinal;
        if (other.isSetParentColumnTableRelations()) {
            ArrayList<ParentColumnTableRelation> __this__parentColumnTableRelations = new ArrayList<ParentColumnTableRelation>(other.parentColumnTableRelations.size());
            for (ParentColumnTableRelation parentColumnTableRelation : other.parentColumnTableRelations) {
                __this__parentColumnTableRelations.add(parentColumnTableRelation);
            }
            this.parentColumnTableRelations = __this__parentColumnTableRelations;
        }
        this.spatialColumn = other.spatialColumn;
    }

    public ColumnSchema deepCopy() {
        return new ColumnSchema(this);
    }

    public void clear() {
        this.data_type = null;
        this.column_name = null;
        this.column_id = null;
        this.setColumnarIsSet(false);
        this.columnar = false;
        this.encoders = null;
        this.setDimensionIsSet(false);
        this.dimension = false;
        this.setColumn_group_idIsSet(false);
        this.column_group_id = 0;
        this.setScaleIsSet(false);
        this.scale = 0;
        this.setPrecisionIsSet(false);
        this.precision = 0;
        this.setNum_childIsSet(false);
        this.num_child = 0;
        this.aggregate_function = null;
        this.default_value = null;
        this.columnProperties = null;
        this.setInvisibleIsSet(false);
        this.invisible = false;
        this.columnReferenceId = null;
        this.setSchemaOrdinalIsSet(false);
        this.schemaOrdinal = 0;
        this.parentColumnTableRelations = null;
        this.setSpatialColumnIsSet(false);
        this.spatialColumn = false;
    }

    public DataType getData_type() {
        return this.data_type;
    }

    public ColumnSchema setData_type(DataType data_type) {
        this.data_type = data_type;
        return this;
    }

    public void unsetData_type() {
        this.data_type = null;
    }

    public boolean isSetData_type() {
        return this.data_type != null;
    }

    public void setData_typeIsSet(boolean value) {
        if (!value) {
            this.data_type = null;
        }
    }

    public String getColumn_name() {
        return this.column_name;
    }

    public ColumnSchema setColumn_name(String column_name) {
        this.column_name = column_name;
        return this;
    }

    public void unsetColumn_name() {
        this.column_name = null;
    }

    public boolean isSetColumn_name() {
        return this.column_name != null;
    }

    public void setColumn_nameIsSet(boolean value) {
        if (!value) {
            this.column_name = null;
        }
    }

    public String getColumn_id() {
        return this.column_id;
    }

    public ColumnSchema setColumn_id(String column_id) {
        this.column_id = column_id;
        return this;
    }

    public void unsetColumn_id() {
        this.column_id = null;
    }

    public boolean isSetColumn_id() {
        return this.column_id != null;
    }

    public void setColumn_idIsSet(boolean value) {
        if (!value) {
            this.column_id = null;
        }
    }

    public boolean isColumnar() {
        return this.columnar;
    }

    public ColumnSchema setColumnar(boolean columnar) {
        this.columnar = columnar;
        this.setColumnarIsSet(true);
        return this;
    }

    public void unsetColumnar() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)0);
    }

    public boolean isSetColumnar() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)0);
    }

    public void setColumnarIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public int getEncodersSize() {
        return this.encoders == null ? 0 : this.encoders.size();
    }

    public Iterator<Encoding> getEncodersIterator() {
        return this.encoders == null ? null : this.encoders.iterator();
    }

    public void addToEncoders(Encoding elem) {
        if (this.encoders == null) {
            this.encoders = new ArrayList<Encoding>();
        }
        this.encoders.add(elem);
    }

    public List<Encoding> getEncoders() {
        return this.encoders;
    }

    public ColumnSchema setEncoders(List<Encoding> encoders) {
        this.encoders = encoders;
        return this;
    }

    public void unsetEncoders() {
        this.encoders = null;
    }

    public boolean isSetEncoders() {
        return this.encoders != null;
    }

    public void setEncodersIsSet(boolean value) {
        if (!value) {
            this.encoders = null;
        }
    }

    public boolean isDimension() {
        return this.dimension;
    }

    public ColumnSchema setDimension(boolean dimension) {
        this.dimension = dimension;
        this.setDimensionIsSet(true);
        return this;
    }

    public void unsetDimension() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)1);
    }

    public boolean isSetDimension() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)1);
    }

    public void setDimensionIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public int getColumn_group_id() {
        return this.column_group_id;
    }

    public ColumnSchema setColumn_group_id(int column_group_id) {
        this.column_group_id = column_group_id;
        this.setColumn_group_idIsSet(true);
        return this;
    }

    public void unsetColumn_group_id() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)2);
    }

    public boolean isSetColumn_group_id() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)2);
    }

    public void setColumn_group_idIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)2, (boolean)value);
    }

    public int getScale() {
        return this.scale;
    }

    public ColumnSchema setScale(int scale) {
        this.scale = scale;
        this.setScaleIsSet(true);
        return this;
    }

    public void unsetScale() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)3);
    }

    public boolean isSetScale() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)3);
    }

    public void setScaleIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)3, (boolean)value);
    }

    public int getPrecision() {
        return this.precision;
    }

    public ColumnSchema setPrecision(int precision) {
        this.precision = precision;
        this.setPrecisionIsSet(true);
        return this;
    }

    public void unsetPrecision() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)4);
    }

    public boolean isSetPrecision() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)4);
    }

    public void setPrecisionIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)4, (boolean)value);
    }

    public int getNum_child() {
        return this.num_child;
    }

    public ColumnSchema setNum_child(int num_child) {
        this.num_child = num_child;
        this.setNum_childIsSet(true);
        return this;
    }

    public void unsetNum_child() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)5);
    }

    public boolean isSetNum_child() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)5);
    }

    public void setNum_childIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)5, (boolean)value);
    }

    public String getAggregate_function() {
        return this.aggregate_function;
    }

    public ColumnSchema setAggregate_function(String aggregate_function) {
        this.aggregate_function = aggregate_function;
        return this;
    }

    public void unsetAggregate_function() {
        this.aggregate_function = null;
    }

    public boolean isSetAggregate_function() {
        return this.aggregate_function != null;
    }

    public void setAggregate_functionIsSet(boolean value) {
        if (!value) {
            this.aggregate_function = null;
        }
    }

    public byte[] getDefault_value() {
        this.setDefault_value(TBaseHelper.rightSize((ByteBuffer)this.default_value));
        return this.default_value == null ? null : this.default_value.array();
    }

    public ByteBuffer bufferForDefault_value() {
        return TBaseHelper.copyBinary((ByteBuffer)this.default_value);
    }

    public ColumnSchema setDefault_value(byte[] default_value) {
        this.default_value = default_value == null ? (ByteBuffer)null : ByteBuffer.wrap(Arrays.copyOf(default_value, default_value.length));
        return this;
    }

    public ColumnSchema setDefault_value(ByteBuffer default_value) {
        this.default_value = TBaseHelper.copyBinary((ByteBuffer)default_value);
        return this;
    }

    public void unsetDefault_value() {
        this.default_value = null;
    }

    public boolean isSetDefault_value() {
        return this.default_value != null;
    }

    public void setDefault_valueIsSet(boolean value) {
        if (!value) {
            this.default_value = null;
        }
    }

    public int getColumnPropertiesSize() {
        return this.columnProperties == null ? 0 : this.columnProperties.size();
    }

    public void putToColumnProperties(String key, String val) {
        if (this.columnProperties == null) {
            this.columnProperties = new HashMap<String, String>();
        }
        this.columnProperties.put(key, val);
    }

    public Map<String, String> getColumnProperties() {
        return this.columnProperties;
    }

    public ColumnSchema setColumnProperties(Map<String, String> columnProperties) {
        this.columnProperties = columnProperties;
        return this;
    }

    public void unsetColumnProperties() {
        this.columnProperties = null;
    }

    public boolean isSetColumnProperties() {
        return this.columnProperties != null;
    }

    public void setColumnPropertiesIsSet(boolean value) {
        if (!value) {
            this.columnProperties = null;
        }
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public ColumnSchema setInvisible(boolean invisible) {
        this.invisible = invisible;
        this.setInvisibleIsSet(true);
        return this;
    }

    public void unsetInvisible() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)6);
    }

    public boolean isSetInvisible() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)6);
    }

    public void setInvisibleIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)6, (boolean)value);
    }

    public String getColumnReferenceId() {
        return this.columnReferenceId;
    }

    public ColumnSchema setColumnReferenceId(String columnReferenceId) {
        this.columnReferenceId = columnReferenceId;
        return this;
    }

    public void unsetColumnReferenceId() {
        this.columnReferenceId = null;
    }

    public boolean isSetColumnReferenceId() {
        return this.columnReferenceId != null;
    }

    public void setColumnReferenceIdIsSet(boolean value) {
        if (!value) {
            this.columnReferenceId = null;
        }
    }

    public int getSchemaOrdinal() {
        return this.schemaOrdinal;
    }

    public ColumnSchema setSchemaOrdinal(int schemaOrdinal) {
        this.schemaOrdinal = schemaOrdinal;
        this.setSchemaOrdinalIsSet(true);
        return this;
    }

    public void unsetSchemaOrdinal() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)7);
    }

    public boolean isSetSchemaOrdinal() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)7);
    }

    public void setSchemaOrdinalIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)7, (boolean)value);
    }

    public int getParentColumnTableRelationsSize() {
        return this.parentColumnTableRelations == null ? 0 : this.parentColumnTableRelations.size();
    }

    public Iterator<ParentColumnTableRelation> getParentColumnTableRelationsIterator() {
        return this.parentColumnTableRelations == null ? null : this.parentColumnTableRelations.iterator();
    }

    public void addToParentColumnTableRelations(ParentColumnTableRelation elem) {
        if (this.parentColumnTableRelations == null) {
            this.parentColumnTableRelations = new ArrayList<ParentColumnTableRelation>();
        }
        this.parentColumnTableRelations.add(elem);
    }

    public List<ParentColumnTableRelation> getParentColumnTableRelations() {
        return this.parentColumnTableRelations;
    }

    public ColumnSchema setParentColumnTableRelations(List<ParentColumnTableRelation> parentColumnTableRelations) {
        this.parentColumnTableRelations = parentColumnTableRelations;
        return this;
    }

    public void unsetParentColumnTableRelations() {
        this.parentColumnTableRelations = null;
    }

    public boolean isSetParentColumnTableRelations() {
        return this.parentColumnTableRelations != null;
    }

    public void setParentColumnTableRelationsIsSet(boolean value) {
        if (!value) {
            this.parentColumnTableRelations = null;
        }
    }

    public boolean isSpatialColumn() {
        return this.spatialColumn;
    }

    public ColumnSchema setSpatialColumn(boolean spatialColumn) {
        this.spatialColumn = spatialColumn;
        this.setSpatialColumnIsSet(true);
        return this;
    }

    public void unsetSpatialColumn() {
        this.__isset_bitfield = EncodingUtils.clearBit((short)this.__isset_bitfield, (int)8);
    }

    public boolean isSetSpatialColumn() {
        return EncodingUtils.testBit((short)this.__isset_bitfield, (int)8);
    }

    public void setSpatialColumnIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((short)this.__isset_bitfield, (int)8, (boolean)value);
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case DATA_TYPE: {
                if (value == null) {
                    this.unsetData_type();
                    break;
                }
                this.setData_type((DataType)((Object)value));
                break;
            }
            case COLUMN_NAME: {
                if (value == null) {
                    this.unsetColumn_name();
                    break;
                }
                this.setColumn_name((String)value);
                break;
            }
            case COLUMN_ID: {
                if (value == null) {
                    this.unsetColumn_id();
                    break;
                }
                this.setColumn_id((String)value);
                break;
            }
            case COLUMNAR: {
                if (value == null) {
                    this.unsetColumnar();
                    break;
                }
                this.setColumnar((Boolean)value);
                break;
            }
            case ENCODERS: {
                if (value == null) {
                    this.unsetEncoders();
                    break;
                }
                this.setEncoders((List)value);
                break;
            }
            case DIMENSION: {
                if (value == null) {
                    this.unsetDimension();
                    break;
                }
                this.setDimension((Boolean)value);
                break;
            }
            case COLUMN_GROUP_ID: {
                if (value == null) {
                    this.unsetColumn_group_id();
                    break;
                }
                this.setColumn_group_id((Integer)value);
                break;
            }
            case SCALE: {
                if (value == null) {
                    this.unsetScale();
                    break;
                }
                this.setScale((Integer)value);
                break;
            }
            case PRECISION: {
                if (value == null) {
                    this.unsetPrecision();
                    break;
                }
                this.setPrecision((Integer)value);
                break;
            }
            case NUM_CHILD: {
                if (value == null) {
                    this.unsetNum_child();
                    break;
                }
                this.setNum_child((Integer)value);
                break;
            }
            case AGGREGATE_FUNCTION: {
                if (value == null) {
                    this.unsetAggregate_function();
                    break;
                }
                this.setAggregate_function((String)value);
                break;
            }
            case DEFAULT_VALUE: {
                if (value == null) {
                    this.unsetDefault_value();
                    break;
                }
                this.setDefault_value((ByteBuffer)value);
                break;
            }
            case COLUMN_PROPERTIES: {
                if (value == null) {
                    this.unsetColumnProperties();
                    break;
                }
                this.setColumnProperties((Map)value);
                break;
            }
            case INVISIBLE: {
                if (value == null) {
                    this.unsetInvisible();
                    break;
                }
                this.setInvisible((Boolean)value);
                break;
            }
            case COLUMN_REFERENCE_ID: {
                if (value == null) {
                    this.unsetColumnReferenceId();
                    break;
                }
                this.setColumnReferenceId((String)value);
                break;
            }
            case SCHEMA_ORDINAL: {
                if (value == null) {
                    this.unsetSchemaOrdinal();
                    break;
                }
                this.setSchemaOrdinal((Integer)value);
                break;
            }
            case PARENT_COLUMN_TABLE_RELATIONS: {
                if (value == null) {
                    this.unsetParentColumnTableRelations();
                    break;
                }
                this.setParentColumnTableRelations((List)value);
                break;
            }
            case SPATIAL_COLUMN: {
                if (value == null) {
                    this.unsetSpatialColumn();
                    break;
                }
                this.setSpatialColumn((Boolean)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case DATA_TYPE: {
                return this.getData_type();
            }
            case COLUMN_NAME: {
                return this.getColumn_name();
            }
            case COLUMN_ID: {
                return this.getColumn_id();
            }
            case COLUMNAR: {
                return this.isColumnar();
            }
            case ENCODERS: {
                return this.getEncoders();
            }
            case DIMENSION: {
                return this.isDimension();
            }
            case COLUMN_GROUP_ID: {
                return this.getColumn_group_id();
            }
            case SCALE: {
                return this.getScale();
            }
            case PRECISION: {
                return this.getPrecision();
            }
            case NUM_CHILD: {
                return this.getNum_child();
            }
            case AGGREGATE_FUNCTION: {
                return this.getAggregate_function();
            }
            case DEFAULT_VALUE: {
                return this.getDefault_value();
            }
            case COLUMN_PROPERTIES: {
                return this.getColumnProperties();
            }
            case INVISIBLE: {
                return this.isInvisible();
            }
            case COLUMN_REFERENCE_ID: {
                return this.getColumnReferenceId();
            }
            case SCHEMA_ORDINAL: {
                return this.getSchemaOrdinal();
            }
            case PARENT_COLUMN_TABLE_RELATIONS: {
                return this.getParentColumnTableRelations();
            }
            case SPATIAL_COLUMN: {
                return this.isSpatialColumn();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case DATA_TYPE: {
                return this.isSetData_type();
            }
            case COLUMN_NAME: {
                return this.isSetColumn_name();
            }
            case COLUMN_ID: {
                return this.isSetColumn_id();
            }
            case COLUMNAR: {
                return this.isSetColumnar();
            }
            case ENCODERS: {
                return this.isSetEncoders();
            }
            case DIMENSION: {
                return this.isSetDimension();
            }
            case COLUMN_GROUP_ID: {
                return this.isSetColumn_group_id();
            }
            case SCALE: {
                return this.isSetScale();
            }
            case PRECISION: {
                return this.isSetPrecision();
            }
            case NUM_CHILD: {
                return this.isSetNum_child();
            }
            case AGGREGATE_FUNCTION: {
                return this.isSetAggregate_function();
            }
            case DEFAULT_VALUE: {
                return this.isSetDefault_value();
            }
            case COLUMN_PROPERTIES: {
                return this.isSetColumnProperties();
            }
            case INVISIBLE: {
                return this.isSetInvisible();
            }
            case COLUMN_REFERENCE_ID: {
                return this.isSetColumnReferenceId();
            }
            case SCHEMA_ORDINAL: {
                return this.isSetSchemaOrdinal();
            }
            case PARENT_COLUMN_TABLE_RELATIONS: {
                return this.isSetParentColumnTableRelations();
            }
            case SPATIAL_COLUMN: {
                return this.isSetSpatialColumn();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof ColumnSchema) {
            return this.equals((ColumnSchema)that);
        }
        return false;
    }

    public boolean equals(ColumnSchema that) {
        if (that == null) {
            return false;
        }
        boolean this_present_data_type = this.isSetData_type();
        boolean that_present_data_type = that.isSetData_type();
        if (this_present_data_type || that_present_data_type) {
            if (!this_present_data_type || !that_present_data_type) {
                return false;
            }
            if (!this.data_type.equals((Object)that.data_type)) {
                return false;
            }
        }
        boolean this_present_column_name = this.isSetColumn_name();
        boolean that_present_column_name = that.isSetColumn_name();
        if (this_present_column_name || that_present_column_name) {
            if (!this_present_column_name || !that_present_column_name) {
                return false;
            }
            if (!this.column_name.equals(that.column_name)) {
                return false;
            }
        }
        boolean this_present_column_id = this.isSetColumn_id();
        boolean that_present_column_id = that.isSetColumn_id();
        if (this_present_column_id || that_present_column_id) {
            if (!this_present_column_id || !that_present_column_id) {
                return false;
            }
            if (!this.column_id.equals(that.column_id)) {
                return false;
            }
        }
        boolean this_present_columnar = true;
        boolean that_present_columnar = true;
        if (this_present_columnar || that_present_columnar) {
            if (!this_present_columnar || !that_present_columnar) {
                return false;
            }
            if (this.columnar != that.columnar) {
                return false;
            }
        }
        boolean this_present_encoders = this.isSetEncoders();
        boolean that_present_encoders = that.isSetEncoders();
        if (this_present_encoders || that_present_encoders) {
            if (!this_present_encoders || !that_present_encoders) {
                return false;
            }
            if (!this.encoders.equals(that.encoders)) {
                return false;
            }
        }
        boolean this_present_dimension = true;
        boolean that_present_dimension = true;
        if (this_present_dimension || that_present_dimension) {
            if (!this_present_dimension || !that_present_dimension) {
                return false;
            }
            if (this.dimension != that.dimension) {
                return false;
            }
        }
        boolean this_present_column_group_id = this.isSetColumn_group_id();
        boolean that_present_column_group_id = that.isSetColumn_group_id();
        if (this_present_column_group_id || that_present_column_group_id) {
            if (!this_present_column_group_id || !that_present_column_group_id) {
                return false;
            }
            if (this.column_group_id != that.column_group_id) {
                return false;
            }
        }
        boolean this_present_scale = this.isSetScale();
        boolean that_present_scale = that.isSetScale();
        if (this_present_scale || that_present_scale) {
            if (!this_present_scale || !that_present_scale) {
                return false;
            }
            if (this.scale != that.scale) {
                return false;
            }
        }
        boolean this_present_precision = this.isSetPrecision();
        boolean that_present_precision = that.isSetPrecision();
        if (this_present_precision || that_present_precision) {
            if (!this_present_precision || !that_present_precision) {
                return false;
            }
            if (this.precision != that.precision) {
                return false;
            }
        }
        boolean this_present_num_child = this.isSetNum_child();
        boolean that_present_num_child = that.isSetNum_child();
        if (this_present_num_child || that_present_num_child) {
            if (!this_present_num_child || !that_present_num_child) {
                return false;
            }
            if (this.num_child != that.num_child) {
                return false;
            }
        }
        boolean this_present_aggregate_function = this.isSetAggregate_function();
        boolean that_present_aggregate_function = that.isSetAggregate_function();
        if (this_present_aggregate_function || that_present_aggregate_function) {
            if (!this_present_aggregate_function || !that_present_aggregate_function) {
                return false;
            }
            if (!this.aggregate_function.equals(that.aggregate_function)) {
                return false;
            }
        }
        boolean this_present_default_value = this.isSetDefault_value();
        boolean that_present_default_value = that.isSetDefault_value();
        if (this_present_default_value || that_present_default_value) {
            if (!this_present_default_value || !that_present_default_value) {
                return false;
            }
            if (!this.default_value.equals(that.default_value)) {
                return false;
            }
        }
        boolean this_present_columnProperties = this.isSetColumnProperties();
        boolean that_present_columnProperties = that.isSetColumnProperties();
        if (this_present_columnProperties || that_present_columnProperties) {
            if (!this_present_columnProperties || !that_present_columnProperties) {
                return false;
            }
            if (!this.columnProperties.equals(that.columnProperties)) {
                return false;
            }
        }
        boolean this_present_invisible = this.isSetInvisible();
        boolean that_present_invisible = that.isSetInvisible();
        if (this_present_invisible || that_present_invisible) {
            if (!this_present_invisible || !that_present_invisible) {
                return false;
            }
            if (this.invisible != that.invisible) {
                return false;
            }
        }
        boolean this_present_columnReferenceId = this.isSetColumnReferenceId();
        boolean that_present_columnReferenceId = that.isSetColumnReferenceId();
        if (this_present_columnReferenceId || that_present_columnReferenceId) {
            if (!this_present_columnReferenceId || !that_present_columnReferenceId) {
                return false;
            }
            if (!this.columnReferenceId.equals(that.columnReferenceId)) {
                return false;
            }
        }
        boolean this_present_schemaOrdinal = this.isSetSchemaOrdinal();
        boolean that_present_schemaOrdinal = that.isSetSchemaOrdinal();
        if (this_present_schemaOrdinal || that_present_schemaOrdinal) {
            if (!this_present_schemaOrdinal || !that_present_schemaOrdinal) {
                return false;
            }
            if (this.schemaOrdinal != that.schemaOrdinal) {
                return false;
            }
        }
        boolean this_present_parentColumnTableRelations = this.isSetParentColumnTableRelations();
        boolean that_present_parentColumnTableRelations = that.isSetParentColumnTableRelations();
        if (this_present_parentColumnTableRelations || that_present_parentColumnTableRelations) {
            if (!this_present_parentColumnTableRelations || !that_present_parentColumnTableRelations) {
                return false;
            }
            if (!this.parentColumnTableRelations.equals(that.parentColumnTableRelations)) {
                return false;
            }
        }
        boolean this_present_spatialColumn = this.isSetSpatialColumn();
        boolean that_present_spatialColumn = that.isSetSpatialColumn();
        if (this_present_spatialColumn || that_present_spatialColumn) {
            if (!this_present_spatialColumn || !that_present_spatialColumn) {
                return false;
            }
            if (this.spatialColumn != that.spatialColumn) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_data_type = this.isSetData_type();
        list.add(present_data_type);
        if (present_data_type) {
            list.add(this.data_type.getValue());
        }
        boolean present_column_name = this.isSetColumn_name();
        list.add(present_column_name);
        if (present_column_name) {
            list.add(this.column_name);
        }
        boolean present_column_id = this.isSetColumn_id();
        list.add(present_column_id);
        if (present_column_id) {
            list.add(this.column_id);
        }
        boolean present_columnar = true;
        list.add(present_columnar);
        if (present_columnar) {
            list.add(this.columnar);
        }
        boolean present_encoders = this.isSetEncoders();
        list.add(present_encoders);
        if (present_encoders) {
            list.add(this.encoders);
        }
        boolean present_dimension = true;
        list.add(present_dimension);
        if (present_dimension) {
            list.add(this.dimension);
        }
        boolean present_column_group_id = this.isSetColumn_group_id();
        list.add(present_column_group_id);
        if (present_column_group_id) {
            list.add(this.column_group_id);
        }
        boolean present_scale = this.isSetScale();
        list.add(present_scale);
        if (present_scale) {
            list.add(this.scale);
        }
        boolean present_precision = this.isSetPrecision();
        list.add(present_precision);
        if (present_precision) {
            list.add(this.precision);
        }
        boolean present_num_child = this.isSetNum_child();
        list.add(present_num_child);
        if (present_num_child) {
            list.add(this.num_child);
        }
        boolean present_aggregate_function = this.isSetAggregate_function();
        list.add(present_aggregate_function);
        if (present_aggregate_function) {
            list.add(this.aggregate_function);
        }
        boolean present_default_value = this.isSetDefault_value();
        list.add(present_default_value);
        if (present_default_value) {
            list.add(this.default_value);
        }
        boolean present_columnProperties = this.isSetColumnProperties();
        list.add(present_columnProperties);
        if (present_columnProperties) {
            list.add(this.columnProperties);
        }
        boolean present_invisible = this.isSetInvisible();
        list.add(present_invisible);
        if (present_invisible) {
            list.add(this.invisible);
        }
        boolean present_columnReferenceId = this.isSetColumnReferenceId();
        list.add(present_columnReferenceId);
        if (present_columnReferenceId) {
            list.add(this.columnReferenceId);
        }
        boolean present_schemaOrdinal = this.isSetSchemaOrdinal();
        list.add(present_schemaOrdinal);
        if (present_schemaOrdinal) {
            list.add(this.schemaOrdinal);
        }
        boolean present_parentColumnTableRelations = this.isSetParentColumnTableRelations();
        list.add(present_parentColumnTableRelations);
        if (present_parentColumnTableRelations) {
            list.add(this.parentColumnTableRelations);
        }
        boolean present_spatialColumn = this.isSetSpatialColumn();
        list.add(present_spatialColumn);
        if (present_spatialColumn) {
            list.add(this.spatialColumn);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(ColumnSchema other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetData_type()).compareTo(other.isSetData_type());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetData_type() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.data_type), (Comparable)((Object)other.data_type))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumn_name()).compareTo(other.isSetColumn_name());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumn_name() && (lastComparison = TBaseHelper.compareTo((String)this.column_name, (String)other.column_name)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumn_id()).compareTo(other.isSetColumn_id());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumn_id() && (lastComparison = TBaseHelper.compareTo((String)this.column_id, (String)other.column_id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumnar()).compareTo(other.isSetColumnar());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumnar() && (lastComparison = TBaseHelper.compareTo((boolean)this.columnar, (boolean)other.columnar)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetEncoders()).compareTo(other.isSetEncoders());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetEncoders() && (lastComparison = TBaseHelper.compareTo(this.encoders, other.encoders)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDimension()).compareTo(other.isSetDimension());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDimension() && (lastComparison = TBaseHelper.compareTo((boolean)this.dimension, (boolean)other.dimension)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumn_group_id()).compareTo(other.isSetColumn_group_id());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumn_group_id() && (lastComparison = TBaseHelper.compareTo((int)this.column_group_id, (int)other.column_group_id)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetScale()).compareTo(other.isSetScale());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetScale() && (lastComparison = TBaseHelper.compareTo((int)this.scale, (int)other.scale)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPrecision()).compareTo(other.isSetPrecision());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPrecision() && (lastComparison = TBaseHelper.compareTo((int)this.precision, (int)other.precision)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetNum_child()).compareTo(other.isSetNum_child());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNum_child() && (lastComparison = TBaseHelper.compareTo((int)this.num_child, (int)other.num_child)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetAggregate_function()).compareTo(other.isSetAggregate_function());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetAggregate_function() && (lastComparison = TBaseHelper.compareTo((String)this.aggregate_function, (String)other.aggregate_function)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDefault_value()).compareTo(other.isSetDefault_value());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDefault_value() && (lastComparison = TBaseHelper.compareTo((Comparable)this.default_value, (Comparable)other.default_value)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumnProperties()).compareTo(other.isSetColumnProperties());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumnProperties() && (lastComparison = TBaseHelper.compareTo(this.columnProperties, other.columnProperties)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetInvisible()).compareTo(other.isSetInvisible());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetInvisible() && (lastComparison = TBaseHelper.compareTo((boolean)this.invisible, (boolean)other.invisible)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumnReferenceId()).compareTo(other.isSetColumnReferenceId());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumnReferenceId() && (lastComparison = TBaseHelper.compareTo((String)this.columnReferenceId, (String)other.columnReferenceId)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSchemaOrdinal()).compareTo(other.isSetSchemaOrdinal());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSchemaOrdinal() && (lastComparison = TBaseHelper.compareTo((int)this.schemaOrdinal, (int)other.schemaOrdinal)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetParentColumnTableRelations()).compareTo(other.isSetParentColumnTableRelations());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetParentColumnTableRelations() && (lastComparison = TBaseHelper.compareTo(this.parentColumnTableRelations, other.parentColumnTableRelations)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSpatialColumn()).compareTo(other.isSetSpatialColumn());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSpatialColumn() && (lastComparison = TBaseHelper.compareTo((boolean)this.spatialColumn, (boolean)other.spatialColumn)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ColumnSchema(");
        boolean first = true;
        sb.append("data_type:");
        if (this.data_type == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.data_type);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("column_name:");
        if (this.column_name == null) {
            sb.append("null");
        } else {
            sb.append(this.column_name);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("column_id:");
        if (this.column_id == null) {
            sb.append("null");
        } else {
            sb.append(this.column_id);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("columnar:");
        sb.append(this.columnar);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("encoders:");
        if (this.encoders == null) {
            sb.append("null");
        } else {
            sb.append(this.encoders);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("dimension:");
        sb.append(this.dimension);
        first = false;
        if (this.isSetColumn_group_id()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("column_group_id:");
            sb.append(this.column_group_id);
            first = false;
        }
        if (this.isSetScale()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("scale:");
            sb.append(this.scale);
            first = false;
        }
        if (this.isSetPrecision()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("precision:");
            sb.append(this.precision);
            first = false;
        }
        if (this.isSetNum_child()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("num_child:");
            sb.append(this.num_child);
            first = false;
        }
        if (this.isSetAggregate_function()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("aggregate_function:");
            if (this.aggregate_function == null) {
                sb.append("null");
            } else {
                sb.append(this.aggregate_function);
            }
            first = false;
        }
        if (this.isSetDefault_value()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("default_value:");
            if (this.default_value == null) {
                sb.append("null");
            } else {
                TBaseHelper.toString((ByteBuffer)this.default_value, (StringBuilder)sb);
            }
            first = false;
        }
        if (this.isSetColumnProperties()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("columnProperties:");
            if (this.columnProperties == null) {
                sb.append("null");
            } else {
                sb.append(this.columnProperties);
            }
            first = false;
        }
        if (this.isSetInvisible()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("invisible:");
            sb.append(this.invisible);
            first = false;
        }
        if (this.isSetColumnReferenceId()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("columnReferenceId:");
            if (this.columnReferenceId == null) {
                sb.append("null");
            } else {
                sb.append(this.columnReferenceId);
            }
            first = false;
        }
        if (this.isSetSchemaOrdinal()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("schemaOrdinal:");
            sb.append(this.schemaOrdinal);
            first = false;
        }
        if (this.isSetParentColumnTableRelations()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("parentColumnTableRelations:");
            if (this.parentColumnTableRelations == null) {
                sb.append("null");
            } else {
                sb.append(this.parentColumnTableRelations);
            }
            first = false;
        }
        if (this.isSetSpatialColumn()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("spatialColumn:");
            sb.append(this.spatialColumn);
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.data_type == null) {
            throw new TProtocolException("Required field 'data_type' was not present! Struct: " + this.toString());
        }
        if (this.column_name == null) {
            throw new TProtocolException("Required field 'column_name' was not present! Struct: " + this.toString());
        }
        if (this.column_id == null) {
            throw new TProtocolException("Required field 'column_id' was not present! Struct: " + this.toString());
        }
        if (this.encoders == null) {
            throw new TProtocolException("Required field 'encoders' was not present! Struct: " + this.toString());
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new ColumnSchemaStandardSchemeFactory());
        schemes.put(TupleScheme.class, new ColumnSchemaTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.COLUMN_GROUP_ID, _Fields.SCALE, _Fields.PRECISION, _Fields.NUM_CHILD, _Fields.AGGREGATE_FUNCTION, _Fields.DEFAULT_VALUE, _Fields.COLUMN_PROPERTIES, _Fields.INVISIBLE, _Fields.COLUMN_REFERENCE_ID, _Fields.SCHEMA_ORDINAL, _Fields.PARENT_COLUMN_TABLE_RELATIONS, _Fields.SPATIAL_COLUMN};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.DATA_TYPE, new FieldMetaData("data_type", 1, (FieldValueMetaData)new EnumMetaData(16, DataType.class)));
        tmpMap.put(_Fields.COLUMN_NAME, new FieldMetaData("column_name", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.COLUMN_ID, new FieldMetaData("column_id", 1, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.COLUMNAR, new FieldMetaData("columnar", 1, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.ENCODERS, new FieldMetaData("encoders", 1, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new EnumMetaData(16, Encoding.class))));
        tmpMap.put(_Fields.DIMENSION, new FieldMetaData("dimension", 1, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.COLUMN_GROUP_ID, new FieldMetaData("column_group_id", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.SCALE, new FieldMetaData("scale", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.PRECISION, new FieldMetaData("precision", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.NUM_CHILD, new FieldMetaData("num_child", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.AGGREGATE_FUNCTION, new FieldMetaData("aggregate_function", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.DEFAULT_VALUE, new FieldMetaData("default_value", 2, new FieldValueMetaData(11, true)));
        tmpMap.put(_Fields.COLUMN_PROPERTIES, new FieldMetaData("columnProperties", 2, (FieldValueMetaData)new MapMetaData(13, new FieldValueMetaData(11), new FieldValueMetaData(11))));
        tmpMap.put(_Fields.INVISIBLE, new FieldMetaData("invisible", 2, new FieldValueMetaData(2)));
        tmpMap.put(_Fields.COLUMN_REFERENCE_ID, new FieldMetaData("columnReferenceId", 2, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.SCHEMA_ORDINAL, new FieldMetaData("schemaOrdinal", 2, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.PARENT_COLUMN_TABLE_RELATIONS, new FieldMetaData("parentColumnTableRelations", 2, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(12, "ParentColumnTableRelation"))));
        tmpMap.put(_Fields.SPATIAL_COLUMN, new FieldMetaData("spatialColumn", 2, new FieldValueMetaData(2)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(ColumnSchema.class, metaDataMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColumnSchemaTupleScheme
    extends TupleScheme<ColumnSchema> {
        private ColumnSchemaTupleScheme() {
        }

        public void write(TProtocol prot, ColumnSchema struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.data_type.getValue());
            oprot.writeString(struct.column_name);
            oprot.writeString(struct.column_id);
            oprot.writeBool(struct.columnar);
            oprot.writeI32(struct.encoders.size());
            for (Encoding _iter13 : struct.encoders) {
                oprot.writeI32(_iter13.getValue());
            }
            oprot.writeBool(struct.dimension);
            BitSet optionals = new BitSet();
            if (struct.isSetColumn_group_id()) {
                optionals.set(0);
            }
            if (struct.isSetScale()) {
                optionals.set(1);
            }
            if (struct.isSetPrecision()) {
                optionals.set(2);
            }
            if (struct.isSetNum_child()) {
                optionals.set(3);
            }
            if (struct.isSetAggregate_function()) {
                optionals.set(4);
            }
            if (struct.isSetDefault_value()) {
                optionals.set(5);
            }
            if (struct.isSetColumnProperties()) {
                optionals.set(6);
            }
            if (struct.isSetInvisible()) {
                optionals.set(7);
            }
            if (struct.isSetColumnReferenceId()) {
                optionals.set(8);
            }
            if (struct.isSetSchemaOrdinal()) {
                optionals.set(9);
            }
            if (struct.isSetParentColumnTableRelations()) {
                optionals.set(10);
            }
            if (struct.isSetSpatialColumn()) {
                optionals.set(11);
            }
            oprot.writeBitSet(optionals, 12);
            if (struct.isSetColumn_group_id()) {
                oprot.writeI32(struct.column_group_id);
            }
            if (struct.isSetScale()) {
                oprot.writeI32(struct.scale);
            }
            if (struct.isSetPrecision()) {
                oprot.writeI32(struct.precision);
            }
            if (struct.isSetNum_child()) {
                oprot.writeI32(struct.num_child);
            }
            if (struct.isSetAggregate_function()) {
                oprot.writeString(struct.aggregate_function);
            }
            if (struct.isSetDefault_value()) {
                oprot.writeBinary(struct.default_value);
            }
            if (struct.isSetColumnProperties()) {
                oprot.writeI32(struct.columnProperties.size());
                for (Map.Entry<String, String> _iter14 : struct.columnProperties.entrySet()) {
                    oprot.writeString(_iter14.getKey());
                    oprot.writeString(_iter14.getValue());
                }
            }
            if (struct.isSetInvisible()) {
                oprot.writeBool(struct.invisible);
            }
            if (struct.isSetColumnReferenceId()) {
                oprot.writeString(struct.columnReferenceId);
            }
            if (struct.isSetSchemaOrdinal()) {
                oprot.writeI32(struct.schemaOrdinal);
            }
            if (struct.isSetParentColumnTableRelations()) {
                oprot.writeI32(struct.parentColumnTableRelations.size());
                for (ParentColumnTableRelation _iter15 : struct.parentColumnTableRelations) {
                    _iter15.write((TProtocol)oprot);
                }
            }
            if (struct.isSetSpatialColumn()) {
                oprot.writeBool(struct.spatialColumn);
            }
        }

        public void read(TProtocol prot, ColumnSchema struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.data_type = DataType.findByValue(iprot.readI32());
            struct.setData_typeIsSet(true);
            struct.column_name = iprot.readString();
            struct.setColumn_nameIsSet(true);
            struct.column_id = iprot.readString();
            struct.setColumn_idIsSet(true);
            struct.columnar = iprot.readBool();
            struct.setColumnarIsSet(true);
            TList _list16 = new TList(8, iprot.readI32());
            struct.encoders = new ArrayList<Encoding>(_list16.size);
            for (int _i18 = 0; _i18 < _list16.size; ++_i18) {
                Encoding _elem17 = Encoding.findByValue(iprot.readI32());
                struct.encoders.add(_elem17);
            }
            struct.setEncodersIsSet(true);
            struct.dimension = iprot.readBool();
            struct.setDimensionIsSet(true);
            BitSet incoming = iprot.readBitSet(12);
            if (incoming.get(0)) {
                struct.column_group_id = iprot.readI32();
                struct.setColumn_group_idIsSet(true);
            }
            if (incoming.get(1)) {
                struct.scale = iprot.readI32();
                struct.setScaleIsSet(true);
            }
            if (incoming.get(2)) {
                struct.precision = iprot.readI32();
                struct.setPrecisionIsSet(true);
            }
            if (incoming.get(3)) {
                struct.num_child = iprot.readI32();
                struct.setNum_childIsSet(true);
            }
            if (incoming.get(4)) {
                struct.aggregate_function = iprot.readString();
                struct.setAggregate_functionIsSet(true);
            }
            if (incoming.get(5)) {
                struct.default_value = iprot.readBinary();
                struct.setDefault_valueIsSet(true);
            }
            if (incoming.get(6)) {
                TMap _map19 = new TMap(11, 11, iprot.readI32());
                struct.columnProperties = new HashMap<String, String>(2 * _map19.size);
                for (int _i22 = 0; _i22 < _map19.size; ++_i22) {
                    String _key20 = iprot.readString();
                    String _val21 = iprot.readString();
                    struct.columnProperties.put(_key20, _val21);
                }
                struct.setColumnPropertiesIsSet(true);
            }
            if (incoming.get(7)) {
                struct.invisible = iprot.readBool();
                struct.setInvisibleIsSet(true);
            }
            if (incoming.get(8)) {
                struct.columnReferenceId = iprot.readString();
                struct.setColumnReferenceIdIsSet(true);
            }
            if (incoming.get(9)) {
                struct.schemaOrdinal = iprot.readI32();
                struct.setSchemaOrdinalIsSet(true);
            }
            if (incoming.get(10)) {
                TList _list23 = new TList(12, iprot.readI32());
                struct.parentColumnTableRelations = new ArrayList<ParentColumnTableRelation>(_list23.size);
                for (int _i25 = 0; _i25 < _list23.size; ++_i25) {
                    ParentColumnTableRelation _elem24 = new ParentColumnTableRelation();
                    _elem24.read((TProtocol)iprot);
                    struct.parentColumnTableRelations.add(_elem24);
                }
                struct.setParentColumnTableRelationsIsSet(true);
            }
            if (incoming.get(11)) {
                struct.spatialColumn = iprot.readBool();
                struct.setSpatialColumnIsSet(true);
            }
        }
    }

    private static class ColumnSchemaTupleSchemeFactory
    implements SchemeFactory {
        private ColumnSchemaTupleSchemeFactory() {
        }

        public ColumnSchemaTupleScheme getScheme() {
            return new ColumnSchemaTupleScheme();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ColumnSchemaStandardScheme
    extends StandardScheme<ColumnSchema> {
        private ColumnSchemaStandardScheme() {
        }

        public void read(TProtocol iprot, ColumnSchema struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 8) {
                            struct.data_type = DataType.findByValue(iprot.readI32());
                            struct.setData_typeIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 11) {
                            struct.column_name = iprot.readString();
                            struct.setColumn_nameIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 11) {
                            struct.column_id = iprot.readString();
                            struct.setColumn_idIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 2) {
                            struct.columnar = iprot.readBool();
                            struct.setColumnarIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 15) {
                            TList _list0 = iprot.readListBegin();
                            struct.encoders = new ArrayList<Encoding>(_list0.size);
                            for (int _i2 = 0; _i2 < _list0.size; ++_i2) {
                                Encoding _elem1 = Encoding.findByValue(iprot.readI32());
                                struct.encoders.add(_elem1);
                            }
                            iprot.readListEnd();
                            struct.setEncodersIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 2) {
                            struct.dimension = iprot.readBool();
                            struct.setDimensionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 8) {
                            struct.column_group_id = iprot.readI32();
                            struct.setColumn_group_idIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 8) {
                            struct.scale = iprot.readI32();
                            struct.setScaleIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 9: {
                        if (schemeField.type == 8) {
                            struct.precision = iprot.readI32();
                            struct.setPrecisionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 10: {
                        if (schemeField.type == 8) {
                            struct.num_child = iprot.readI32();
                            struct.setNum_childIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 11: {
                        if (schemeField.type == 11) {
                            struct.aggregate_function = iprot.readString();
                            struct.setAggregate_functionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 12: {
                        if (schemeField.type == 11) {
                            struct.default_value = iprot.readBinary();
                            struct.setDefault_valueIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 13: {
                        if (schemeField.type == 13) {
                            TMap _map3 = iprot.readMapBegin();
                            struct.columnProperties = new HashMap<String, String>(2 * _map3.size);
                            for (int _i6 = 0; _i6 < _map3.size; ++_i6) {
                                String _key4 = iprot.readString();
                                String _val5 = iprot.readString();
                                struct.columnProperties.put(_key4, _val5);
                            }
                            iprot.readMapEnd();
                            struct.setColumnPropertiesIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 14: {
                        if (schemeField.type == 2) {
                            struct.invisible = iprot.readBool();
                            struct.setInvisibleIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 15: {
                        if (schemeField.type == 11) {
                            struct.columnReferenceId = iprot.readString();
                            struct.setColumnReferenceIdIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 16: {
                        if (schemeField.type == 8) {
                            struct.schemaOrdinal = iprot.readI32();
                            struct.setSchemaOrdinalIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 17: {
                        if (schemeField.type == 15) {
                            TList _list7 = iprot.readListBegin();
                            struct.parentColumnTableRelations = new ArrayList<ParentColumnTableRelation>(_list7.size);
                            for (int _i9 = 0; _i9 < _list7.size; ++_i9) {
                                ParentColumnTableRelation _elem8 = new ParentColumnTableRelation();
                                _elem8.read(iprot);
                                struct.parentColumnTableRelations.add(_elem8);
                            }
                            iprot.readListEnd();
                            struct.setParentColumnTableRelationsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 18: {
                        if (schemeField.type == 2) {
                            struct.spatialColumn = iprot.readBool();
                            struct.setSpatialColumnIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetColumnar()) {
                throw new TProtocolException("Required field 'columnar' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetDimension()) {
                throw new TProtocolException("Required field 'dimension' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, ColumnSchema struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            if (struct.data_type != null) {
                oprot.writeFieldBegin(DATA_TYPE_FIELD_DESC);
                oprot.writeI32(struct.data_type.getValue());
                oprot.writeFieldEnd();
            }
            if (struct.column_name != null) {
                oprot.writeFieldBegin(COLUMN_NAME_FIELD_DESC);
                oprot.writeString(struct.column_name);
                oprot.writeFieldEnd();
            }
            if (struct.column_id != null) {
                oprot.writeFieldBegin(COLUMN_ID_FIELD_DESC);
                oprot.writeString(struct.column_id);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(COLUMNAR_FIELD_DESC);
            oprot.writeBool(struct.columnar);
            oprot.writeFieldEnd();
            if (struct.encoders != null) {
                oprot.writeFieldBegin(ENCODERS_FIELD_DESC);
                oprot.writeListBegin(new TList(8, struct.encoders.size()));
                for (Encoding encoding : struct.encoders) {
                    oprot.writeI32(encoding.getValue());
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            oprot.writeFieldBegin(DIMENSION_FIELD_DESC);
            oprot.writeBool(struct.dimension);
            oprot.writeFieldEnd();
            if (struct.isSetColumn_group_id()) {
                oprot.writeFieldBegin(COLUMN_GROUP_ID_FIELD_DESC);
                oprot.writeI32(struct.column_group_id);
                oprot.writeFieldEnd();
            }
            if (struct.isSetScale()) {
                oprot.writeFieldBegin(SCALE_FIELD_DESC);
                oprot.writeI32(struct.scale);
                oprot.writeFieldEnd();
            }
            if (struct.isSetPrecision()) {
                oprot.writeFieldBegin(PRECISION_FIELD_DESC);
                oprot.writeI32(struct.precision);
                oprot.writeFieldEnd();
            }
            if (struct.isSetNum_child()) {
                oprot.writeFieldBegin(NUM_CHILD_FIELD_DESC);
                oprot.writeI32(struct.num_child);
                oprot.writeFieldEnd();
            }
            if (struct.aggregate_function != null && struct.isSetAggregate_function()) {
                oprot.writeFieldBegin(AGGREGATE_FUNCTION_FIELD_DESC);
                oprot.writeString(struct.aggregate_function);
                oprot.writeFieldEnd();
            }
            if (struct.default_value != null && struct.isSetDefault_value()) {
                oprot.writeFieldBegin(DEFAULT_VALUE_FIELD_DESC);
                oprot.writeBinary(struct.default_value);
                oprot.writeFieldEnd();
            }
            if (struct.columnProperties != null && struct.isSetColumnProperties()) {
                oprot.writeFieldBegin(COLUMN_PROPERTIES_FIELD_DESC);
                oprot.writeMapBegin(new TMap(11, 11, struct.columnProperties.size()));
                for (Map.Entry entry : struct.columnProperties.entrySet()) {
                    oprot.writeString((String)entry.getKey());
                    oprot.writeString((String)entry.getValue());
                }
                oprot.writeMapEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetInvisible()) {
                oprot.writeFieldBegin(INVISIBLE_FIELD_DESC);
                oprot.writeBool(struct.invisible);
                oprot.writeFieldEnd();
            }
            if (struct.columnReferenceId != null && struct.isSetColumnReferenceId()) {
                oprot.writeFieldBegin(COLUMN_REFERENCE_ID_FIELD_DESC);
                oprot.writeString(struct.columnReferenceId);
                oprot.writeFieldEnd();
            }
            if (struct.isSetSchemaOrdinal()) {
                oprot.writeFieldBegin(SCHEMA_ORDINAL_FIELD_DESC);
                oprot.writeI32(struct.schemaOrdinal);
                oprot.writeFieldEnd();
            }
            if (struct.parentColumnTableRelations != null && struct.isSetParentColumnTableRelations()) {
                oprot.writeFieldBegin(PARENT_COLUMN_TABLE_RELATIONS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.parentColumnTableRelations.size()));
                for (ParentColumnTableRelation parentColumnTableRelation : struct.parentColumnTableRelations) {
                    parentColumnTableRelation.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.isSetSpatialColumn()) {
                oprot.writeFieldBegin(SPATIAL_COLUMN_FIELD_DESC);
                oprot.writeBool(struct.spatialColumn);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class ColumnSchemaStandardSchemeFactory
    implements SchemeFactory {
        private ColumnSchemaStandardSchemeFactory() {
        }

        public ColumnSchemaStandardScheme getScheme() {
            return new ColumnSchemaStandardScheme();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum _Fields implements TFieldIdEnum
    {
        DATA_TYPE(1, "data_type"),
        COLUMN_NAME(2, "column_name"),
        COLUMN_ID(3, "column_id"),
        COLUMNAR(4, "columnar"),
        ENCODERS(5, "encoders"),
        DIMENSION(6, "dimension"),
        COLUMN_GROUP_ID(7, "column_group_id"),
        SCALE(8, "scale"),
        PRECISION(9, "precision"),
        NUM_CHILD(10, "num_child"),
        AGGREGATE_FUNCTION(11, "aggregate_function"),
        DEFAULT_VALUE(12, "default_value"),
        COLUMN_PROPERTIES(13, "columnProperties"),
        INVISIBLE(14, "invisible"),
        COLUMN_REFERENCE_ID(15, "columnReferenceId"),
        SCHEMA_ORDINAL(16, "schemaOrdinal"),
        PARENT_COLUMN_TABLE_RELATIONS(17, "parentColumnTableRelations"),
        SPATIAL_COLUMN(18, "spatialColumn");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return DATA_TYPE;
                }
                case 2: {
                    return COLUMN_NAME;
                }
                case 3: {
                    return COLUMN_ID;
                }
                case 4: {
                    return COLUMNAR;
                }
                case 5: {
                    return ENCODERS;
                }
                case 6: {
                    return DIMENSION;
                }
                case 7: {
                    return COLUMN_GROUP_ID;
                }
                case 8: {
                    return SCALE;
                }
                case 9: {
                    return PRECISION;
                }
                case 10: {
                    return NUM_CHILD;
                }
                case 11: {
                    return AGGREGATE_FUNCTION;
                }
                case 12: {
                    return DEFAULT_VALUE;
                }
                case 13: {
                    return COLUMN_PROPERTIES;
                }
                case 14: {
                    return INVISIBLE;
                }
                case 15: {
                    return COLUMN_REFERENCE_ID;
                }
                case 16: {
                    return SCHEMA_ORDINAL;
                }
                case 17: {
                    return PARENT_COLUMN_TABLE_RELATIONS;
                }
                case 18: {
                    return SPATIAL_COLUMN;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

