/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.format;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.format.BlockletIndex;
import org.apache.carbondata.format.BlockletInfo;
import org.apache.carbondata.format.BlockletInfo2;
import org.apache.carbondata.format.ColumnDictionaryChunk;
import org.apache.carbondata.format.ColumnSchema;
import org.apache.carbondata.format.SegmentInfo;
import org.apache.thrift.EncodingUtils;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.meta_data.StructMetaData;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;
import org.apache.thrift.protocol.TTupleProtocol;
import org.apache.thrift.scheme.IScheme;
import org.apache.thrift.scheme.SchemeFactory;
import org.apache.thrift.scheme.StandardScheme;
import org.apache.thrift.scheme.TupleScheme;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileFooter
implements TBase<FileFooter, _Fields>,
Serializable,
Cloneable,
Comparable<FileFooter> {
    private static final TStruct STRUCT_DESC = new TStruct("FileFooter");
    private static final TField VERSION_FIELD_DESC = new TField("version", 8, 1);
    private static final TField NUM_ROWS_FIELD_DESC = new TField("num_rows", 10, 2);
    private static final TField TABLE_COLUMNS_FIELD_DESC = new TField("table_columns", 15, 3);
    private static final TField SEGMENT_INFO_FIELD_DESC = new TField("segment_info", 12, 4);
    private static final TField BLOCKLET_INDEX_LIST_FIELD_DESC = new TField("blocklet_index_list", 15, 5);
    private static final TField BLOCKLET_INFO_LIST_FIELD_DESC = new TField("blocklet_info_list", 15, 6);
    private static final TField BLOCKLET_INFO_LIST2_FIELD_DESC = new TField("blocklet_info_list2", 15, 7);
    private static final TField DICTIONARY_FIELD_DESC = new TField("dictionary", 12, 8);
    private static final Map<Class<? extends IScheme>, SchemeFactory> schemes = new HashMap<Class<? extends IScheme>, SchemeFactory>();
    public int version;
    public long num_rows;
    public List<ColumnSchema> table_columns;
    public SegmentInfo segment_info;
    public List<BlockletIndex> blocklet_index_list;
    public List<BlockletInfo> blocklet_info_list;
    public List<BlockletInfo2> blocklet_info_list2;
    public ColumnDictionaryChunk dictionary;
    private static final int __VERSION_ISSET_ID = 0;
    private static final int __NUM_ROWS_ISSET_ID = 1;
    private byte __isset_bitfield = 0;
    private static final _Fields[] optionals;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public FileFooter() {
    }

    public FileFooter(int version, long num_rows, List<ColumnSchema> table_columns, SegmentInfo segment_info, List<BlockletIndex> blocklet_index_list) {
        this();
        this.version = version;
        this.setVersionIsSet(true);
        this.num_rows = num_rows;
        this.setNum_rowsIsSet(true);
        this.table_columns = table_columns;
        this.segment_info = segment_info;
        this.blocklet_index_list = blocklet_index_list;
    }

    public FileFooter(FileFooter other) {
        this.__isset_bitfield = other.__isset_bitfield;
        this.version = other.version;
        this.num_rows = other.num_rows;
        if (other.isSetTable_columns()) {
            ArrayList<ColumnSchema> __this__table_columns = new ArrayList<ColumnSchema>(other.table_columns.size());
            for (ColumnSchema columnSchema : other.table_columns) {
                __this__table_columns.add(new ColumnSchema(columnSchema));
            }
            this.table_columns = __this__table_columns;
        }
        if (other.isSetSegment_info()) {
            this.segment_info = new SegmentInfo(other.segment_info);
        }
        if (other.isSetBlocklet_index_list()) {
            ArrayList<BlockletIndex> __this__blocklet_index_list = new ArrayList<BlockletIndex>(other.blocklet_index_list.size());
            for (BlockletIndex blockletIndex : other.blocklet_index_list) {
                __this__blocklet_index_list.add(new BlockletIndex(blockletIndex));
            }
            this.blocklet_index_list = __this__blocklet_index_list;
        }
        if (other.isSetBlocklet_info_list()) {
            ArrayList<BlockletInfo> __this__blocklet_info_list = new ArrayList<BlockletInfo>(other.blocklet_info_list.size());
            for (BlockletInfo blockletInfo : other.blocklet_info_list) {
                __this__blocklet_info_list.add(new BlockletInfo(blockletInfo));
            }
            this.blocklet_info_list = __this__blocklet_info_list;
        }
        if (other.isSetBlocklet_info_list2()) {
            ArrayList<BlockletInfo2> __this__blocklet_info_list2 = new ArrayList<BlockletInfo2>(other.blocklet_info_list2.size());
            for (BlockletInfo2 blockletInfo2 : other.blocklet_info_list2) {
                __this__blocklet_info_list2.add(new BlockletInfo2(blockletInfo2));
            }
            this.blocklet_info_list2 = __this__blocklet_info_list2;
        }
        if (other.isSetDictionary()) {
            this.dictionary = new ColumnDictionaryChunk(other.dictionary);
        }
    }

    public FileFooter deepCopy() {
        return new FileFooter(this);
    }

    public void clear() {
        this.setVersionIsSet(false);
        this.version = 0;
        this.setNum_rowsIsSet(false);
        this.num_rows = 0L;
        this.table_columns = null;
        this.segment_info = null;
        this.blocklet_index_list = null;
        this.blocklet_info_list = null;
        this.blocklet_info_list2 = null;
        this.dictionary = null;
    }

    public int getVersion() {
        return this.version;
    }

    public FileFooter setVersion(int version) {
        this.version = version;
        this.setVersionIsSet(true);
        return this;
    }

    public void unsetVersion() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)0);
    }

    public boolean isSetVersion() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)0);
    }

    public void setVersionIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)0, (boolean)value);
    }

    public long getNum_rows() {
        return this.num_rows;
    }

    public FileFooter setNum_rows(long num_rows) {
        this.num_rows = num_rows;
        this.setNum_rowsIsSet(true);
        return this;
    }

    public void unsetNum_rows() {
        this.__isset_bitfield = EncodingUtils.clearBit((byte)this.__isset_bitfield, (int)1);
    }

    public boolean isSetNum_rows() {
        return EncodingUtils.testBit((byte)this.__isset_bitfield, (int)1);
    }

    public void setNum_rowsIsSet(boolean value) {
        this.__isset_bitfield = EncodingUtils.setBit((byte)this.__isset_bitfield, (int)1, (boolean)value);
    }

    public int getTable_columnsSize() {
        return this.table_columns == null ? 0 : this.table_columns.size();
    }

    public Iterator<ColumnSchema> getTable_columnsIterator() {
        return this.table_columns == null ? null : this.table_columns.iterator();
    }

    public void addToTable_columns(ColumnSchema elem) {
        if (this.table_columns == null) {
            this.table_columns = new ArrayList<ColumnSchema>();
        }
        this.table_columns.add(elem);
    }

    public List<ColumnSchema> getTable_columns() {
        return this.table_columns;
    }

    public FileFooter setTable_columns(List<ColumnSchema> table_columns) {
        this.table_columns = table_columns;
        return this;
    }

    public void unsetTable_columns() {
        this.table_columns = null;
    }

    public boolean isSetTable_columns() {
        return this.table_columns != null;
    }

    public void setTable_columnsIsSet(boolean value) {
        if (!value) {
            this.table_columns = null;
        }
    }

    public SegmentInfo getSegment_info() {
        return this.segment_info;
    }

    public FileFooter setSegment_info(SegmentInfo segment_info) {
        this.segment_info = segment_info;
        return this;
    }

    public void unsetSegment_info() {
        this.segment_info = null;
    }

    public boolean isSetSegment_info() {
        return this.segment_info != null;
    }

    public void setSegment_infoIsSet(boolean value) {
        if (!value) {
            this.segment_info = null;
        }
    }

    public int getBlocklet_index_listSize() {
        return this.blocklet_index_list == null ? 0 : this.blocklet_index_list.size();
    }

    public Iterator<BlockletIndex> getBlocklet_index_listIterator() {
        return this.blocklet_index_list == null ? null : this.blocklet_index_list.iterator();
    }

    public void addToBlocklet_index_list(BlockletIndex elem) {
        if (this.blocklet_index_list == null) {
            this.blocklet_index_list = new ArrayList<BlockletIndex>();
        }
        this.blocklet_index_list.add(elem);
    }

    public List<BlockletIndex> getBlocklet_index_list() {
        return this.blocklet_index_list;
    }

    public FileFooter setBlocklet_index_list(List<BlockletIndex> blocklet_index_list) {
        this.blocklet_index_list = blocklet_index_list;
        return this;
    }

    public void unsetBlocklet_index_list() {
        this.blocklet_index_list = null;
    }

    public boolean isSetBlocklet_index_list() {
        return this.blocklet_index_list != null;
    }

    public void setBlocklet_index_listIsSet(boolean value) {
        if (!value) {
            this.blocklet_index_list = null;
        }
    }

    public int getBlocklet_info_listSize() {
        return this.blocklet_info_list == null ? 0 : this.blocklet_info_list.size();
    }

    public Iterator<BlockletInfo> getBlocklet_info_listIterator() {
        return this.blocklet_info_list == null ? null : this.blocklet_info_list.iterator();
    }

    public void addToBlocklet_info_list(BlockletInfo elem) {
        if (this.blocklet_info_list == null) {
            this.blocklet_info_list = new ArrayList<BlockletInfo>();
        }
        this.blocklet_info_list.add(elem);
    }

    public List<BlockletInfo> getBlocklet_info_list() {
        return this.blocklet_info_list;
    }

    public FileFooter setBlocklet_info_list(List<BlockletInfo> blocklet_info_list) {
        this.blocklet_info_list = blocklet_info_list;
        return this;
    }

    public void unsetBlocklet_info_list() {
        this.blocklet_info_list = null;
    }

    public boolean isSetBlocklet_info_list() {
        return this.blocklet_info_list != null;
    }

    public void setBlocklet_info_listIsSet(boolean value) {
        if (!value) {
            this.blocklet_info_list = null;
        }
    }

    public int getBlocklet_info_list2Size() {
        return this.blocklet_info_list2 == null ? 0 : this.blocklet_info_list2.size();
    }

    public Iterator<BlockletInfo2> getBlocklet_info_list2Iterator() {
        return this.blocklet_info_list2 == null ? null : this.blocklet_info_list2.iterator();
    }

    public void addToBlocklet_info_list2(BlockletInfo2 elem) {
        if (this.blocklet_info_list2 == null) {
            this.blocklet_info_list2 = new ArrayList<BlockletInfo2>();
        }
        this.blocklet_info_list2.add(elem);
    }

    public List<BlockletInfo2> getBlocklet_info_list2() {
        return this.blocklet_info_list2;
    }

    public FileFooter setBlocklet_info_list2(List<BlockletInfo2> blocklet_info_list2) {
        this.blocklet_info_list2 = blocklet_info_list2;
        return this;
    }

    public void unsetBlocklet_info_list2() {
        this.blocklet_info_list2 = null;
    }

    public boolean isSetBlocklet_info_list2() {
        return this.blocklet_info_list2 != null;
    }

    public void setBlocklet_info_list2IsSet(boolean value) {
        if (!value) {
            this.blocklet_info_list2 = null;
        }
    }

    public ColumnDictionaryChunk getDictionary() {
        return this.dictionary;
    }

    public FileFooter setDictionary(ColumnDictionaryChunk dictionary) {
        this.dictionary = dictionary;
        return this;
    }

    public void unsetDictionary() {
        this.dictionary = null;
    }

    public boolean isSetDictionary() {
        return this.dictionary != null;
    }

    public void setDictionaryIsSet(boolean value) {
        if (!value) {
            this.dictionary = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case VERSION: {
                if (value == null) {
                    this.unsetVersion();
                    break;
                }
                this.setVersion((Integer)value);
                break;
            }
            case NUM_ROWS: {
                if (value == null) {
                    this.unsetNum_rows();
                    break;
                }
                this.setNum_rows((Long)value);
                break;
            }
            case TABLE_COLUMNS: {
                if (value == null) {
                    this.unsetTable_columns();
                    break;
                }
                this.setTable_columns((List)value);
                break;
            }
            case SEGMENT_INFO: {
                if (value == null) {
                    this.unsetSegment_info();
                    break;
                }
                this.setSegment_info((SegmentInfo)value);
                break;
            }
            case BLOCKLET_INDEX_LIST: {
                if (value == null) {
                    this.unsetBlocklet_index_list();
                    break;
                }
                this.setBlocklet_index_list((List)value);
                break;
            }
            case BLOCKLET_INFO_LIST: {
                if (value == null) {
                    this.unsetBlocklet_info_list();
                    break;
                }
                this.setBlocklet_info_list((List)value);
                break;
            }
            case BLOCKLET_INFO_LIST2: {
                if (value == null) {
                    this.unsetBlocklet_info_list2();
                    break;
                }
                this.setBlocklet_info_list2((List)value);
                break;
            }
            case DICTIONARY: {
                if (value == null) {
                    this.unsetDictionary();
                    break;
                }
                this.setDictionary((ColumnDictionaryChunk)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case VERSION: {
                return this.getVersion();
            }
            case NUM_ROWS: {
                return this.getNum_rows();
            }
            case TABLE_COLUMNS: {
                return this.getTable_columns();
            }
            case SEGMENT_INFO: {
                return this.getSegment_info();
            }
            case BLOCKLET_INDEX_LIST: {
                return this.getBlocklet_index_list();
            }
            case BLOCKLET_INFO_LIST: {
                return this.getBlocklet_info_list();
            }
            case BLOCKLET_INFO_LIST2: {
                return this.getBlocklet_info_list2();
            }
            case DICTIONARY: {
                return this.getDictionary();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case VERSION: {
                return this.isSetVersion();
            }
            case NUM_ROWS: {
                return this.isSetNum_rows();
            }
            case TABLE_COLUMNS: {
                return this.isSetTable_columns();
            }
            case SEGMENT_INFO: {
                return this.isSetSegment_info();
            }
            case BLOCKLET_INDEX_LIST: {
                return this.isSetBlocklet_index_list();
            }
            case BLOCKLET_INFO_LIST: {
                return this.isSetBlocklet_info_list();
            }
            case BLOCKLET_INFO_LIST2: {
                return this.isSetBlocklet_info_list2();
            }
            case DICTIONARY: {
                return this.isSetDictionary();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof FileFooter) {
            return this.equals((FileFooter)that);
        }
        return false;
    }

    public boolean equals(FileFooter that) {
        if (that == null) {
            return false;
        }
        boolean this_present_version = true;
        boolean that_present_version = true;
        if (this_present_version || that_present_version) {
            if (!this_present_version || !that_present_version) {
                return false;
            }
            if (this.version != that.version) {
                return false;
            }
        }
        boolean this_present_num_rows = true;
        boolean that_present_num_rows = true;
        if (this_present_num_rows || that_present_num_rows) {
            if (!this_present_num_rows || !that_present_num_rows) {
                return false;
            }
            if (this.num_rows != that.num_rows) {
                return false;
            }
        }
        boolean this_present_table_columns = this.isSetTable_columns();
        boolean that_present_table_columns = that.isSetTable_columns();
        if (this_present_table_columns || that_present_table_columns) {
            if (!this_present_table_columns || !that_present_table_columns) {
                return false;
            }
            if (!this.table_columns.equals(that.table_columns)) {
                return false;
            }
        }
        boolean this_present_segment_info = this.isSetSegment_info();
        boolean that_present_segment_info = that.isSetSegment_info();
        if (this_present_segment_info || that_present_segment_info) {
            if (!this_present_segment_info || !that_present_segment_info) {
                return false;
            }
            if (!this.segment_info.equals(that.segment_info)) {
                return false;
            }
        }
        boolean this_present_blocklet_index_list = this.isSetBlocklet_index_list();
        boolean that_present_blocklet_index_list = that.isSetBlocklet_index_list();
        if (this_present_blocklet_index_list || that_present_blocklet_index_list) {
            if (!this_present_blocklet_index_list || !that_present_blocklet_index_list) {
                return false;
            }
            if (!this.blocklet_index_list.equals(that.blocklet_index_list)) {
                return false;
            }
        }
        boolean this_present_blocklet_info_list = this.isSetBlocklet_info_list();
        boolean that_present_blocklet_info_list = that.isSetBlocklet_info_list();
        if (this_present_blocklet_info_list || that_present_blocklet_info_list) {
            if (!this_present_blocklet_info_list || !that_present_blocklet_info_list) {
                return false;
            }
            if (!this.blocklet_info_list.equals(that.blocklet_info_list)) {
                return false;
            }
        }
        boolean this_present_blocklet_info_list2 = this.isSetBlocklet_info_list2();
        boolean that_present_blocklet_info_list2 = that.isSetBlocklet_info_list2();
        if (this_present_blocklet_info_list2 || that_present_blocklet_info_list2) {
            if (!this_present_blocklet_info_list2 || !that_present_blocklet_info_list2) {
                return false;
            }
            if (!this.blocklet_info_list2.equals(that.blocklet_info_list2)) {
                return false;
            }
        }
        boolean this_present_dictionary = this.isSetDictionary();
        boolean that_present_dictionary = that.isSetDictionary();
        if (this_present_dictionary || that_present_dictionary) {
            if (!this_present_dictionary || !that_present_dictionary) {
                return false;
            }
            if (!this.dictionary.equals(that.dictionary)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean present_version = true;
        list.add(present_version);
        if (present_version) {
            list.add(this.version);
        }
        boolean present_num_rows = true;
        list.add(present_num_rows);
        if (present_num_rows) {
            list.add(this.num_rows);
        }
        boolean present_table_columns = this.isSetTable_columns();
        list.add(present_table_columns);
        if (present_table_columns) {
            list.add(this.table_columns);
        }
        boolean present_segment_info = this.isSetSegment_info();
        list.add(present_segment_info);
        if (present_segment_info) {
            list.add(this.segment_info);
        }
        boolean present_blocklet_index_list = this.isSetBlocklet_index_list();
        list.add(present_blocklet_index_list);
        if (present_blocklet_index_list) {
            list.add(this.blocklet_index_list);
        }
        boolean present_blocklet_info_list = this.isSetBlocklet_info_list();
        list.add(present_blocklet_info_list);
        if (present_blocklet_info_list) {
            list.add(this.blocklet_info_list);
        }
        boolean present_blocklet_info_list2 = this.isSetBlocklet_info_list2();
        list.add(present_blocklet_info_list2);
        if (present_blocklet_info_list2) {
            list.add(this.blocklet_info_list2);
        }
        boolean present_dictionary = this.isSetDictionary();
        list.add(present_dictionary);
        if (present_dictionary) {
            list.add(this.dictionary);
        }
        return list.hashCode();
    }

    @Override
    public int compareTo(FileFooter other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetVersion()).compareTo(other.isSetVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetVersion() && (lastComparison = TBaseHelper.compareTo((int)this.version, (int)other.version)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetNum_rows()).compareTo(other.isSetNum_rows());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetNum_rows() && (lastComparison = TBaseHelper.compareTo((long)this.num_rows, (long)other.num_rows)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetTable_columns()).compareTo(other.isSetTable_columns());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetTable_columns() && (lastComparison = TBaseHelper.compareTo(this.table_columns, other.table_columns)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetSegment_info()).compareTo(other.isSetSegment_info());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetSegment_info() && (lastComparison = TBaseHelper.compareTo((Comparable)this.segment_info, (Comparable)other.segment_info)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetBlocklet_index_list()).compareTo(other.isSetBlocklet_index_list());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBlocklet_index_list() && (lastComparison = TBaseHelper.compareTo(this.blocklet_index_list, other.blocklet_index_list)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetBlocklet_info_list()).compareTo(other.isSetBlocklet_info_list());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBlocklet_info_list() && (lastComparison = TBaseHelper.compareTo(this.blocklet_info_list, other.blocklet_info_list)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetBlocklet_info_list2()).compareTo(other.isSetBlocklet_info_list2());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetBlocklet_info_list2() && (lastComparison = TBaseHelper.compareTo(this.blocklet_info_list2, other.blocklet_info_list2)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDictionary()).compareTo(other.isSetDictionary());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDictionary() && (lastComparison = TBaseHelper.compareTo((Comparable)this.dictionary, (Comparable)other.dictionary)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        schemes.get(iprot.getScheme()).getScheme().read(iprot, (TBase)this);
    }

    public void write(TProtocol oprot) throws TException {
        schemes.get(oprot.getScheme()).getScheme().write(oprot, (TBase)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FileFooter(");
        boolean first = true;
        sb.append("version:");
        sb.append(this.version);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("num_rows:");
        sb.append(this.num_rows);
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("table_columns:");
        if (this.table_columns == null) {
            sb.append("null");
        } else {
            sb.append(this.table_columns);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("segment_info:");
        if (this.segment_info == null) {
            sb.append("null");
        } else {
            sb.append(this.segment_info);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("blocklet_index_list:");
        if (this.blocklet_index_list == null) {
            sb.append("null");
        } else {
            sb.append(this.blocklet_index_list);
        }
        first = false;
        if (this.isSetBlocklet_info_list()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("blocklet_info_list:");
            if (this.blocklet_info_list == null) {
                sb.append("null");
            } else {
                sb.append(this.blocklet_info_list);
            }
            first = false;
        }
        if (this.isSetBlocklet_info_list2()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("blocklet_info_list2:");
            if (this.blocklet_info_list2 == null) {
                sb.append("null");
            } else {
                sb.append(this.blocklet_info_list2);
            }
            first = false;
        }
        if (this.isSetDictionary()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append("dictionary:");
            if (this.dictionary == null) {
                sb.append("null");
            } else {
                sb.append(this.dictionary);
            }
            first = false;
        }
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.table_columns == null) {
            throw new TProtocolException("Required field 'table_columns' was not present! Struct: " + this.toString());
        }
        if (this.segment_info == null) {
            throw new TProtocolException("Required field 'segment_info' was not present! Struct: " + this.toString());
        }
        if (this.blocklet_index_list == null) {
            throw new TProtocolException("Required field 'blocklet_index_list' was not present! Struct: " + this.toString());
        }
        if (this.segment_info != null) {
            this.segment_info.validate();
        }
        if (this.dictionary != null) {
            this.dictionary.validate();
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        try {
            this.write((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((OutputStream)out)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        try {
            this.__isset_bitfield = 0;
            this.read((TProtocol)new TCompactProtocol((TTransport)new TIOStreamTransport((InputStream)in)));
        }
        catch (TException te) {
            throw new IOException(te);
        }
    }

    static {
        schemes.put(StandardScheme.class, new FileFooterStandardSchemeFactory());
        schemes.put(TupleScheme.class, new FileFooterTupleSchemeFactory());
        optionals = new _Fields[]{_Fields.BLOCKLET_INFO_LIST, _Fields.BLOCKLET_INFO_LIST2, _Fields.DICTIONARY};
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.VERSION, new FieldMetaData("version", 1, new FieldValueMetaData(8)));
        tmpMap.put(_Fields.NUM_ROWS, new FieldMetaData("num_rows", 1, new FieldValueMetaData(10)));
        tmpMap.put(_Fields.TABLE_COLUMNS, new FieldMetaData("table_columns", 1, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, ColumnSchema.class))));
        tmpMap.put(_Fields.SEGMENT_INFO, new FieldMetaData("segment_info", 1, (FieldValueMetaData)new StructMetaData(12, SegmentInfo.class)));
        tmpMap.put(_Fields.BLOCKLET_INDEX_LIST, new FieldMetaData("blocklet_index_list", 1, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, BlockletIndex.class))));
        tmpMap.put(_Fields.BLOCKLET_INFO_LIST, new FieldMetaData("blocklet_info_list", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, BlockletInfo.class))));
        tmpMap.put(_Fields.BLOCKLET_INFO_LIST2, new FieldMetaData("blocklet_info_list2", 2, (FieldValueMetaData)new ListMetaData(15, (FieldValueMetaData)new StructMetaData(12, BlockletInfo2.class))));
        tmpMap.put(_Fields.DICTIONARY, new FieldMetaData("dictionary", 2, (FieldValueMetaData)new StructMetaData(12, ColumnDictionaryChunk.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(FileFooter.class, metaDataMap);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileFooterTupleScheme
    extends TupleScheme<FileFooter> {
        private FileFooterTupleScheme() {
        }

        public void write(TProtocol prot, FileFooter struct) throws TException {
            TTupleProtocol oprot = (TTupleProtocol)prot;
            oprot.writeI32(struct.version);
            oprot.writeI64(struct.num_rows);
            oprot.writeI32(struct.table_columns.size());
            for (ColumnSchema _iter160 : struct.table_columns) {
                _iter160.write((TProtocol)oprot);
            }
            struct.segment_info.write((TProtocol)oprot);
            oprot.writeI32(struct.blocklet_index_list.size());
            for (BlockletIndex _iter161 : struct.blocklet_index_list) {
                _iter161.write((TProtocol)oprot);
            }
            BitSet optionals = new BitSet();
            if (struct.isSetBlocklet_info_list()) {
                optionals.set(0);
            }
            if (struct.isSetBlocklet_info_list2()) {
                optionals.set(1);
            }
            if (struct.isSetDictionary()) {
                optionals.set(2);
            }
            oprot.writeBitSet(optionals, 3);
            if (struct.isSetBlocklet_info_list()) {
                oprot.writeI32(struct.blocklet_info_list.size());
                for (BlockletInfo _iter162 : struct.blocklet_info_list) {
                    _iter162.write((TProtocol)oprot);
                }
            }
            if (struct.isSetBlocklet_info_list2()) {
                oprot.writeI32(struct.blocklet_info_list2.size());
                for (BlockletInfo2 _iter163 : struct.blocklet_info_list2) {
                    _iter163.write((TProtocol)oprot);
                }
            }
            if (struct.isSetDictionary()) {
                struct.dictionary.write((TProtocol)oprot);
            }
        }

        public void read(TProtocol prot, FileFooter struct) throws TException {
            TTupleProtocol iprot = (TTupleProtocol)prot;
            struct.version = iprot.readI32();
            struct.setVersionIsSet(true);
            struct.num_rows = iprot.readI64();
            struct.setNum_rowsIsSet(true);
            TList _list164 = new TList(12, iprot.readI32());
            struct.table_columns = new ArrayList<ColumnSchema>(_list164.size);
            for (int _i166 = 0; _i166 < _list164.size; ++_i166) {
                ColumnSchema _elem165 = new ColumnSchema();
                _elem165.read((TProtocol)iprot);
                struct.table_columns.add(_elem165);
            }
            struct.setTable_columnsIsSet(true);
            struct.segment_info = new SegmentInfo();
            struct.segment_info.read((TProtocol)iprot);
            struct.setSegment_infoIsSet(true);
            TList _list167 = new TList(12, iprot.readI32());
            struct.blocklet_index_list = new ArrayList<BlockletIndex>(_list167.size);
            for (int _i169 = 0; _i169 < _list167.size; ++_i169) {
                BlockletIndex _elem168 = new BlockletIndex();
                _elem168.read((TProtocol)iprot);
                struct.blocklet_index_list.add(_elem168);
            }
            struct.setBlocklet_index_listIsSet(true);
            BitSet incoming = iprot.readBitSet(3);
            if (incoming.get(0)) {
                TList _list170 = new TList(12, iprot.readI32());
                struct.blocklet_info_list = new ArrayList<BlockletInfo>(_list170.size);
                for (int _i172 = 0; _i172 < _list170.size; ++_i172) {
                    BlockletInfo _elem171 = new BlockletInfo();
                    _elem171.read((TProtocol)iprot);
                    struct.blocklet_info_list.add(_elem171);
                }
                struct.setBlocklet_info_listIsSet(true);
            }
            if (incoming.get(1)) {
                TList _list173 = new TList(12, iprot.readI32());
                struct.blocklet_info_list2 = new ArrayList<BlockletInfo2>(_list173.size);
                for (int _i175 = 0; _i175 < _list173.size; ++_i175) {
                    BlockletInfo2 _elem174 = new BlockletInfo2();
                    _elem174.read((TProtocol)iprot);
                    struct.blocklet_info_list2.add(_elem174);
                }
                struct.setBlocklet_info_list2IsSet(true);
            }
            if (incoming.get(2)) {
                struct.dictionary = new ColumnDictionaryChunk();
                struct.dictionary.read((TProtocol)iprot);
                struct.setDictionaryIsSet(true);
            }
        }
    }

    private static class FileFooterTupleSchemeFactory
    implements SchemeFactory {
        private FileFooterTupleSchemeFactory() {
        }

        public FileFooterTupleScheme getScheme() {
            return new FileFooterTupleScheme();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FileFooterStandardScheme
    extends StandardScheme<FileFooter> {
        private FileFooterStandardScheme() {
        }

        public void read(TProtocol iprot, FileFooter struct) throws TException {
            iprot.readStructBegin();
            while (true) {
                TField schemeField = iprot.readFieldBegin();
                if (schemeField.type == 0) break;
                switch (schemeField.id) {
                    case 1: {
                        if (schemeField.type == 8) {
                            struct.version = iprot.readI32();
                            struct.setVersionIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 2: {
                        if (schemeField.type == 10) {
                            struct.num_rows = iprot.readI64();
                            struct.setNum_rowsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 3: {
                        if (schemeField.type == 15) {
                            TList _list144 = iprot.readListBegin();
                            struct.table_columns = new ArrayList<ColumnSchema>(_list144.size);
                            for (int _i146 = 0; _i146 < _list144.size; ++_i146) {
                                ColumnSchema _elem145 = new ColumnSchema();
                                _elem145.read(iprot);
                                struct.table_columns.add(_elem145);
                            }
                            iprot.readListEnd();
                            struct.setTable_columnsIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 4: {
                        if (schemeField.type == 12) {
                            struct.segment_info = new SegmentInfo();
                            struct.segment_info.read(iprot);
                            struct.setSegment_infoIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 5: {
                        if (schemeField.type == 15) {
                            TList _list147 = iprot.readListBegin();
                            struct.blocklet_index_list = new ArrayList<BlockletIndex>(_list147.size);
                            for (int _i149 = 0; _i149 < _list147.size; ++_i149) {
                                BlockletIndex _elem148 = new BlockletIndex();
                                _elem148.read(iprot);
                                struct.blocklet_index_list.add(_elem148);
                            }
                            iprot.readListEnd();
                            struct.setBlocklet_index_listIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 6: {
                        if (schemeField.type == 15) {
                            TList _list150 = iprot.readListBegin();
                            struct.blocklet_info_list = new ArrayList<BlockletInfo>(_list150.size);
                            for (int _i152 = 0; _i152 < _list150.size; ++_i152) {
                                BlockletInfo _elem151 = new BlockletInfo();
                                _elem151.read(iprot);
                                struct.blocklet_info_list.add(_elem151);
                            }
                            iprot.readListEnd();
                            struct.setBlocklet_info_listIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 7: {
                        if (schemeField.type == 15) {
                            TList _list153 = iprot.readListBegin();
                            struct.blocklet_info_list2 = new ArrayList<BlockletInfo2>(_list153.size);
                            for (int _i155 = 0; _i155 < _list153.size; ++_i155) {
                                BlockletInfo2 _elem154 = new BlockletInfo2();
                                _elem154.read(iprot);
                                struct.blocklet_info_list2.add(_elem154);
                            }
                            iprot.readListEnd();
                            struct.setBlocklet_info_list2IsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    case 8: {
                        if (schemeField.type == 12) {
                            struct.dictionary = new ColumnDictionaryChunk();
                            struct.dictionary.read(iprot);
                            struct.setDictionaryIsSet(true);
                            break;
                        }
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                        break;
                    }
                    default: {
                        TProtocolUtil.skip((TProtocol)iprot, (byte)schemeField.type);
                    }
                }
                iprot.readFieldEnd();
            }
            iprot.readStructEnd();
            if (!struct.isSetVersion()) {
                throw new TProtocolException("Required field 'version' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            if (!struct.isSetNum_rows()) {
                throw new TProtocolException("Required field 'num_rows' was not found in serialized data! Struct: " + ((Object)((Object)this)).toString());
            }
            struct.validate();
        }

        public void write(TProtocol oprot, FileFooter struct) throws TException {
            struct.validate();
            oprot.writeStructBegin(STRUCT_DESC);
            oprot.writeFieldBegin(VERSION_FIELD_DESC);
            oprot.writeI32(struct.version);
            oprot.writeFieldEnd();
            oprot.writeFieldBegin(NUM_ROWS_FIELD_DESC);
            oprot.writeI64(struct.num_rows);
            oprot.writeFieldEnd();
            if (struct.table_columns != null) {
                oprot.writeFieldBegin(TABLE_COLUMNS_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.table_columns.size()));
                for (ColumnSchema _iter156 : struct.table_columns) {
                    _iter156.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.segment_info != null) {
                oprot.writeFieldBegin(SEGMENT_INFO_FIELD_DESC);
                struct.segment_info.write(oprot);
                oprot.writeFieldEnd();
            }
            if (struct.blocklet_index_list != null) {
                oprot.writeFieldBegin(BLOCKLET_INDEX_LIST_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.blocklet_index_list.size()));
                for (BlockletIndex _iter157 : struct.blocklet_index_list) {
                    _iter157.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.blocklet_info_list != null && struct.isSetBlocklet_info_list()) {
                oprot.writeFieldBegin(BLOCKLET_INFO_LIST_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.blocklet_info_list.size()));
                for (BlockletInfo _iter158 : struct.blocklet_info_list) {
                    _iter158.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.blocklet_info_list2 != null && struct.isSetBlocklet_info_list2()) {
                oprot.writeFieldBegin(BLOCKLET_INFO_LIST2_FIELD_DESC);
                oprot.writeListBegin(new TList(12, struct.blocklet_info_list2.size()));
                for (BlockletInfo2 _iter159 : struct.blocklet_info_list2) {
                    _iter159.write(oprot);
                }
                oprot.writeListEnd();
                oprot.writeFieldEnd();
            }
            if (struct.dictionary != null && struct.isSetDictionary()) {
                oprot.writeFieldBegin(DICTIONARY_FIELD_DESC);
                struct.dictionary.write(oprot);
                oprot.writeFieldEnd();
            }
            oprot.writeFieldStop();
            oprot.writeStructEnd();
        }
    }

    private static class FileFooterStandardSchemeFactory
    implements SchemeFactory {
        private FileFooterStandardSchemeFactory() {
        }

        public FileFooterStandardScheme getScheme() {
            return new FileFooterStandardScheme();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum _Fields implements TFieldIdEnum
    {
        VERSION(1, "version"),
        NUM_ROWS(2, "num_rows"),
        TABLE_COLUMNS(3, "table_columns"),
        SEGMENT_INFO(4, "segment_info"),
        BLOCKLET_INDEX_LIST(5, "blocklet_index_list"),
        BLOCKLET_INFO_LIST(6, "blocklet_info_list"),
        BLOCKLET_INFO_LIST2(7, "blocklet_info_list2"),
        DICTIONARY(8, "dictionary");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return VERSION;
                }
                case 2: {
                    return NUM_ROWS;
                }
                case 3: {
                    return TABLE_COLUMNS;
                }
                case 4: {
                    return SEGMENT_INFO;
                }
                case 5: {
                    return BLOCKLET_INDEX_LIST;
                }
                case 6: {
                    return BLOCKLET_INFO_LIST;
                }
                case 7: {
                    return BLOCKLET_INFO_LIST2;
                }
                case 8: {
                    return DICTIONARY;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

