/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.readsupport.impl;

import java.io.IOException;
import org.apache.carbondata.core.cache.Cache;
import org.apache.carbondata.core.cache.CacheProvider;
import org.apache.carbondata.core.cache.CacheType;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.cache.dictionary.DictionaryColumnUniqueIdentifier;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.hadoop.readsupport.CarbonReadSupport;

public class DictionaryDecodeReadSupport<T>
implements CarbonReadSupport<T> {
    protected Dictionary[] dictionaries;
    protected DataType[] dataTypes;
    protected CarbonColumn[] carbonColumns;

    @Override
    public void initialize(CarbonColumn[] carbonColumns, CarbonTable carbonTable) throws IOException {
        this.carbonColumns = carbonColumns;
        this.dictionaries = new Dictionary[carbonColumns.length];
        this.dataTypes = new DataType[carbonColumns.length];
        for (int i = 0; i < carbonColumns.length; ++i) {
            if (carbonColumns[i].hasEncoding(Encoding.DICTIONARY) && !carbonColumns[i].hasEncoding(Encoding.DIRECT_DICTIONARY) && !carbonColumns[i].isComplex().booleanValue()) {
                CacheProvider cacheProvider = CacheProvider.getInstance();
                Cache forwardDictionaryCache = cacheProvider.createCache(CacheType.FORWARD_DICTIONARY);
                this.dataTypes[i] = carbonColumns[i].getDataType();
                String dictionaryPath = (String)carbonTable.getTableInfo().getFactTable().getTableProperties().get("dictionary_path");
                this.dictionaries[i] = (Dictionary)forwardDictionaryCache.get((Object)new DictionaryColumnUniqueIdentifier(carbonTable.getAbsoluteTableIdentifier(), carbonColumns[i].getColumnIdentifier(), this.dataTypes[i], dictionaryPath));
                continue;
            }
            this.dataTypes[i] = carbonColumns[i].getDataType();
        }
    }

    @Override
    public T readRow(Object[] data) {
        assert (data.length == this.dictionaries.length);
        for (int i = 0; i < this.dictionaries.length; ++i) {
            if (this.dictionaries[i] == null) continue;
            data[i] = this.dictionaries[i].getDictionaryValueForKey(((Integer)data[i]).intValue());
        }
        return (T)data;
    }

    @Override
    public void close() {
        if (this.dictionaries == null) {
            return;
        }
        for (int i = 0; i < this.dictionaries.length; ++i) {
            CarbonUtil.clearDictionaryCache((Dictionary)this.dictionaries[i]);
        }
    }
}

