/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.hadoop.util;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datamap.DataMapJob;
import org.apache.carbondata.core.datamap.DataMapUtil;
import org.apache.carbondata.core.exception.InvalidConfigurationException;
import org.apache.carbondata.core.indexstore.PartitionSpec;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.scan.expression.Expression;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonSessionInfo;
import org.apache.carbondata.core.util.ThreadLocalSessionInfo;
import org.apache.carbondata.hadoop.CarbonProjection;
import org.apache.carbondata.hadoop.api.CarbonInputFormat;
import org.apache.carbondata.hadoop.api.CarbonTableInputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class CarbonInputFormatUtil {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)CarbonProperties.class.getName());

    public static <V> CarbonTableInputFormat<V> createCarbonInputFormat(AbsoluteTableIdentifier identifier, Job job) throws IOException {
        CarbonTableInputFormat carbonInputFormat = new CarbonTableInputFormat();
        CarbonTableInputFormat.setDatabaseName(job.getConfiguration(), identifier.getCarbonTableIdentifier().getDatabaseName());
        CarbonTableInputFormat.setTableName(job.getConfiguration(), identifier.getCarbonTableIdentifier().getTableName());
        FileInputFormat.addInputPath((Job)job, (Path)new Path(identifier.getTablePath()));
        CarbonInputFormatUtil.setDataMapJobIfConfigured(job.getConfiguration());
        return carbonInputFormat;
    }

    public static <V> CarbonTableInputFormat<V> createCarbonTableInputFormat(AbsoluteTableIdentifier identifier, List<String> partitionId, Job job) throws IOException {
        CarbonTableInputFormat carbonTableInputFormat = new CarbonTableInputFormat();
        CarbonTableInputFormat.setPartitionIdList(job.getConfiguration(), partitionId);
        CarbonTableInputFormat.setDatabaseName(job.getConfiguration(), identifier.getCarbonTableIdentifier().getDatabaseName());
        CarbonTableInputFormat.setTableName(job.getConfiguration(), identifier.getCarbonTableIdentifier().getTableName());
        FileInputFormat.addInputPath((Job)job, (Path)new Path(identifier.getTablePath()));
        CarbonInputFormatUtil.setDataMapJobIfConfigured(job.getConfiguration());
        return carbonTableInputFormat;
    }

    public static <V> CarbonTableInputFormat<V> createCarbonTableInputFormat(Job job, CarbonTable carbonTable, String[] projectionColumns, Expression filterExpression, List<PartitionSpec> partitionNames, DataMapJob dataMapJob) throws IOException, InvalidConfigurationException {
        Configuration conf = job.getConfiguration();
        CarbonInputFormat.setTableInfo(conf, carbonTable.getTableInfo());
        CarbonInputFormat.setDatabaseName(conf, carbonTable.getTableInfo().getDatabaseName());
        CarbonInputFormat.setTableName(conf, carbonTable.getTableInfo().getFactTable().getTableName());
        if (partitionNames != null) {
            CarbonInputFormat.setPartitionsToPrune(conf, partitionNames);
        }
        CarbonInputFormat.setTransactionalTable(conf, carbonTable.getTableInfo().isTransactionalTable());
        CarbonProjection columnProjection = new CarbonProjection(projectionColumns);
        return CarbonInputFormatUtil.createInputFormat(conf, carbonTable.getAbsoluteTableIdentifier(), filterExpression, columnProjection, dataMapJob);
    }

    private static <V> CarbonTableInputFormat<V> createInputFormat(Configuration conf, AbsoluteTableIdentifier identifier, Expression filterExpression, CarbonProjection columnProjection, DataMapJob dataMapJob) throws InvalidConfigurationException, IOException {
        CarbonTableInputFormat format = new CarbonTableInputFormat();
        CarbonInputFormat.setTablePath(conf, identifier.appendWithLocalPrefix(identifier.getTablePath()));
        CarbonInputFormat.setQuerySegment(conf, identifier);
        CarbonInputFormat.setFilterPredicates(conf, filterExpression);
        CarbonInputFormat.setColumnProjection(conf, columnProjection);
        if (dataMapJob != null) {
            DataMapUtil.setDataMapJob((Configuration)conf, (Object)dataMapJob);
        } else {
            CarbonInputFormatUtil.setDataMapJobIfConfigured(conf);
        }
        CarbonSessionInfo carbonSessionInfo = ThreadLocalSessionInfo.getCarbonSessionInfo();
        if (carbonSessionInfo != null) {
            String tableUniqueKey = identifier.getDatabaseName() + "." + identifier.getTableName();
            String validateInputSegmentsKey = "validate.carbon.input.segments." + tableUniqueKey;
            CarbonInputFormat.setValidateSegmentsToAccess(conf, Boolean.valueOf(carbonSessionInfo.getThreadParams().getProperty(validateInputSegmentsKey, "true")));
            String queryOnPreAggStreamingKey = "carbon.query.on.preagg.streaming." + tableUniqueKey;
            boolean queryOnPreAggStreaming = Boolean.valueOf(carbonSessionInfo.getThreadParams().getProperty(queryOnPreAggStreamingKey, "false"));
            String inputSegmentsKey = "carbon.input.segments." + tableUniqueKey;
            CarbonInputFormat.setValidateSegmentsToAccess(conf, Boolean.valueOf(carbonSessionInfo.getThreadParams().getProperty(validateInputSegmentsKey, "true")));
            CarbonInputFormat.setQuerySegment(conf, carbonSessionInfo.getThreadParams().getProperty(inputSegmentsKey, CarbonProperties.getInstance().getProperty(inputSegmentsKey, "*")));
            if (queryOnPreAggStreaming) {
                CarbonInputFormat.setAccessStreamingSegments(conf, true);
                carbonSessionInfo.getThreadParams().removeProperty(queryOnPreAggStreamingKey);
                carbonSessionInfo.getThreadParams().removeProperty(inputSegmentsKey);
                carbonSessionInfo.getThreadParams().removeProperty(validateInputSegmentsKey);
            }
        }
        return format;
    }

    public static void setDataMapJobIfConfigured(Configuration conf) throws IOException {
        String className = "org.apache.carbondata.spark.rdd.SparkDataMapJob";
        DataMapUtil.setDataMapJob((Configuration)conf, (Object)DataMapUtil.createDataMapJob((String)className));
    }

    public static String createJobTrackerID(Date date) {
        return new SimpleDateFormat("yyyyMMddHHmmss", Locale.US).format(date);
    }

    public static JobID getJobId(Date date, int batch) {
        String jobtrackerID = CarbonInputFormatUtil.createJobTrackerID(date);
        return new JobID(jobtrackerID, batch);
    }
}

