/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading;

import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.processing.datamap.DataMapWriterListener;
import org.apache.carbondata.processing.loading.CarbonDataLoadConfiguration;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.carbondata.processing.loading.row.CarbonRowBatch;

public abstract class AbstractDataLoadProcessorStep {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)AbstractDataLoadProcessorStep.class.getName());
    protected CarbonDataLoadConfiguration configuration;
    protected AbstractDataLoadProcessorStep child;
    protected AtomicLong rowCounter;
    protected boolean closed;

    public AbstractDataLoadProcessorStep(CarbonDataLoadConfiguration configuration, AbstractDataLoadProcessorStep child) {
        this.configuration = configuration;
        this.child = child;
        this.rowCounter = new AtomicLong();
        this.closed = false;
    }

    public DataField[] getOutput() {
        return this.child.getOutput();
    }

    public void initialize() throws IOException {
        if (LOGGER.isInfoEnabled()) {
            new Thread(){

                @Override
                public void run() {
                    while (!AbstractDataLoadProcessorStep.this.closed) {
                        try {
                            LOGGER.info("Rows processed in step " + AbstractDataLoadProcessorStep.this.getStepName() + " : " + AbstractDataLoadProcessorStep.this.rowCounter.get());
                            Thread.sleep(10000L);
                        }
                        catch (InterruptedException e) {
                            LOGGER.error(e.getMessage());
                        }
                    }
                }
            }.start();
        }
    }

    public abstract Iterator<CarbonRowBatch>[] execute() throws CarbonDataLoadingException;

    protected CarbonRowBatch processRowBatch(CarbonRowBatch rowBatch) {
        CarbonRowBatch newBatch = new CarbonRowBatch(rowBatch.getSize());
        while (rowBatch.hasNext()) {
            newBatch.addRow(null);
        }
        return newBatch;
    }

    protected abstract String getStepName();

    protected DataMapWriterListener getDataMapWriterListener(int bucketId) {
        return null;
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            LOGGER.info("Total rows processed in step " + this.getStepName() + ": " + this.rowCounter.get());
            if (this.child != null) {
                this.child.close();
            }
        }
    }
}

