/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.datastore.filesystem.CarbonFile;
import org.apache.carbondata.core.datastore.filesystem.CarbonFileFilter;
import org.apache.carbondata.core.datastore.impl.FileFactory;
import org.apache.carbondata.core.metadata.schema.table.CarbonTable;
import org.apache.carbondata.core.statusmanager.LoadMetadataDetails;
import org.apache.carbondata.core.statusmanager.SegmentStatusManager;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.core.util.CarbonThreadFactory;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.path.CarbonTablePath;
import org.apache.carbondata.processing.loading.model.CarbonLoadModel;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;
import org.apache.carbondata.processing.util.CarbonLoaderUtil;
import org.apache.commons.lang3.StringUtils;

public class TableProcessingOperations {
    private static final LogService LOGGER = LogServiceFactory.getLogService((String)CarbonLoaderUtil.class.getName());

    public static void deletePartialLoadDataIfExist(CarbonTable carbonTable, boolean isCompactionFlow) throws IOException {
        FileFactory.FileType fileType;
        String metaDataLocation = carbonTable.getMetadataPath();
        final LoadMetadataDetails[] details = SegmentStatusManager.readLoadMetadata((String)metaDataLocation);
        String partitionPath = CarbonTablePath.getPartitionDir((String)carbonTable.getTablePath());
        if (FileFactory.isFileExist((String)partitionPath, (FileFactory.FileType)(fileType = FileFactory.getFileType((String)partitionPath)))) {
            CarbonFile carbonFile = FileFactory.getCarbonFile((String)partitionPath, (FileFactory.FileType)fileType);
            CarbonFile[] listFiles = carbonFile.listFiles(new CarbonFileFilter(){

                public boolean accept(CarbonFile path) {
                    String segmentId = CarbonTablePath.DataFileUtil.getSegmentIdFromPath((String)(path.getAbsolutePath() + "/dummy"));
                    boolean found = false;
                    for (int j = 0; j < details.length; ++j) {
                        if (!details[j].getLoadName().equals(segmentId)) continue;
                        found = true;
                        break;
                    }
                    return !found;
                }
            });
            for (int k = 0; k < listFiles.length; ++k) {
                String segmentId = CarbonTablePath.DataFileUtil.getSegmentIdFromPath((String)(listFiles[k].getAbsolutePath() + "/dummy"));
                if (isCompactionFlow) {
                    if (!segmentId.contains(".")) continue;
                    CarbonLoaderUtil.deleteStorePath(listFiles[k].getAbsolutePath());
                    continue;
                }
                if (segmentId.contains(".")) continue;
                CarbonLoaderUtil.deleteStorePath(listFiles[k].getAbsolutePath());
            }
        }
    }

    public static void deleteLocalDataLoadFolderLocation(CarbonLoadModel loadModel, boolean isCompactionFlow, boolean isAltPartitionFlow) {
        String tableName = loadModel.getTableName();
        String databaseName = loadModel.getDatabaseName();
        String tempLocationKey = CarbonDataProcessorUtil.getTempStoreLocationKey(databaseName, tableName, loadModel.getSegmentId(), loadModel.getTaskNo(), isCompactionFlow, isAltPartitionFlow);
        TableProcessingOperations.deleteLocalDataLoadFolderLocation(tempLocationKey, tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteLocalDataLoadFolderLocation(String tempLocationKey, String tableName) {
        final String localStoreLocations = CarbonProperties.getInstance().getProperty(tempLocationKey);
        if (localStoreLocations == null) {
            throw new RuntimeException("Store location not set for the key " + tempLocationKey);
        }
        ExecutorService localFolderDeletionService = Executors.newFixedThreadPool(1, (ThreadFactory)new CarbonThreadFactory("LocalFolderDeletionPool:" + tableName));
        try {
            localFolderDeletionService.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    String[] locArray;
                    long startTime = System.currentTimeMillis();
                    for (String loc : locArray = StringUtils.split((String)localStoreLocations, (String)File.pathSeparator)) {
                        try {
                            CarbonUtil.deleteFoldersAndFiles((File[])new File[]{new File(loc)});
                        }
                        catch (IOException | InterruptedException e) {
                            LOGGER.error((Throwable)e, "Failed to delete local data load folder location: " + loc);
                        }
                    }
                    LOGGER.info("Deleted the local store location: " + localStoreLocations + " : Time taken: " + (System.currentTimeMillis() - startTime));
                    return null;
                }
            });
        }
        finally {
            if (null != localFolderDeletionService) {
                localFolderDeletionService.shutdown();
            }
        }
    }
}

