/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.converter.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.cache.Cache;
import org.apache.carbondata.core.cache.CacheProvider;
import org.apache.carbondata.core.cache.CacheType;
import org.apache.carbondata.core.cache.dictionary.Dictionary;
import org.apache.carbondata.core.cache.dictionary.DictionaryColumnUniqueIdentifier;
import org.apache.carbondata.core.datastore.row.CarbonRow;
import org.apache.carbondata.core.devapi.BiDictionary;
import org.apache.carbondata.core.devapi.DictionaryGenerationException;
import org.apache.carbondata.core.dictionary.client.DictionaryClient;
import org.apache.carbondata.core.dictionary.generator.key.DictionaryMessage;
import org.apache.carbondata.core.dictionary.generator.key.DictionaryMessageType;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.util.CarbonUtil;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.processing.loading.converter.BadRecordLogHolder;
import org.apache.carbondata.processing.loading.converter.impl.AbstractDictionaryFieldConverterImpl;
import org.apache.carbondata.processing.loading.dictionary.DictionaryServerClientDictionary;
import org.apache.carbondata.processing.loading.dictionary.PreCreatedDictionary;
import org.apache.carbondata.processing.loading.exception.CarbonDataLoadingException;
import org.apache.carbondata.processing.util.CarbonDataProcessorUtil;

public class DictionaryFieldConverterImpl
extends AbstractDictionaryFieldConverterImpl {
    private BiDictionary<Integer, Object> dictionaryGenerator;
    private int index;
    private CarbonDimension carbonDimension;
    private String nullFormat;
    private Dictionary dictionary;
    private DictionaryMessage dictionaryMessage;
    private boolean isEmptyBadRecord;

    public DictionaryFieldConverterImpl(CarbonColumn carbonColumn, String tableId, String nullFormat, int index, DictionaryClient client, boolean useOnePass, Map<Object, Integer> localCache, boolean isEmptyBadRecord, DictionaryColumnUniqueIdentifier identifier) throws IOException {
        this.index = index;
        assert (carbonColumn instanceof CarbonDimension);
        this.carbonDimension = (CarbonDimension)carbonColumn;
        this.nullFormat = nullFormat;
        this.isEmptyBadRecord = isEmptyBadRecord;
        CacheProvider cacheProvider = CacheProvider.getInstance();
        Cache cache = cacheProvider.createCache(CacheType.REVERSE_DICTIONARY);
        if (useOnePass) {
            if (CarbonUtil.isFileExistsForGivenColumn((DictionaryColumnUniqueIdentifier)identifier)) {
                this.dictionary = (Dictionary)cache.get((Object)identifier);
            }
            this.dictionaryMessage = new DictionaryMessage();
            this.dictionaryMessage.setColumnName(carbonColumn.getColName());
            this.dictionaryMessage.setTableUniqueId(tableId);
            this.dictionaryMessage.setData("0");
            this.dictionaryMessage.setType(DictionaryMessageType.DICT_GENERATION);
            this.dictionaryGenerator = new DictionaryServerClientDictionary(this.dictionary, client, this.dictionaryMessage, localCache);
        } else {
            this.dictionary = (Dictionary)cache.get((Object)identifier);
            this.dictionaryGenerator = new PreCreatedDictionary(this.dictionary);
        }
    }

    @Override
    public void convert(CarbonRow row, BadRecordLogHolder logHolder) throws CarbonDataLoadingException {
        try {
            row.update(this.convert(row.getString(this.index), logHolder), this.index);
        }
        catch (RuntimeException e) {
            throw new CarbonDataLoadingException(e);
        }
    }

    @Override
    public Object convert(Object value, BadRecordLogHolder logHolder) throws RuntimeException {
        try {
            String parsedValue = null;
            String dimensionValue = (String)value;
            parsedValue = dimensionValue == null || dimensionValue.equals(this.nullFormat) ? "@NU#LL$!" : DataTypeUtil.parseValue((String)dimensionValue, (CarbonDimension)this.carbonDimension);
            if (null == parsedValue) {
                if (dimensionValue.length() > 0 || dimensionValue.length() == 0 && this.isEmptyBadRecord) {
                    String message = logHolder.getColumnMessageMap().get(this.carbonDimension.getColName());
                    if (null == message) {
                        message = CarbonDataProcessorUtil.prepareFailureReason(this.carbonDimension.getColName(), this.carbonDimension.getDataType());
                        logHolder.getColumnMessageMap().put(this.carbonDimension.getColName(), message);
                    }
                    logHolder.setReason(message);
                }
                return 1;
            }
            return this.dictionaryGenerator.getOrGenerateKey((Object)parsedValue);
        }
        catch (DictionaryGenerationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void clear() {
        CarbonUtil.clearDictionaryCache((Dictionary)this.dictionary);
    }

    @Override
    public void fillColumnCardinality(List<Integer> cardinality) {
        cardinality.add(this.dictionaryGenerator.size());
    }
}

