/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.converter.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.carbondata.core.cache.dictionary.DictionaryColumnUniqueIdentifier;
import org.apache.carbondata.core.dictionary.client.DictionaryClient;
import org.apache.carbondata.core.metadata.AbsoluteTableIdentifier;
import org.apache.carbondata.core.metadata.CarbonTableIdentifier;
import org.apache.carbondata.core.metadata.ColumnIdentifier;
import org.apache.carbondata.core.metadata.datatype.DataType;
import org.apache.carbondata.core.metadata.datatype.DataTypes;
import org.apache.carbondata.core.metadata.encoder.Encoding;
import org.apache.carbondata.core.metadata.schema.table.RelationIdentifier;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonColumn;
import org.apache.carbondata.core.metadata.schema.table.column.CarbonDimension;
import org.apache.carbondata.core.metadata.schema.table.column.ParentColumnTableRelation;
import org.apache.carbondata.core.util.DataTypeUtil;
import org.apache.carbondata.processing.datatypes.ArrayDataType;
import org.apache.carbondata.processing.datatypes.GenericDataType;
import org.apache.carbondata.processing.datatypes.PrimitiveDataType;
import org.apache.carbondata.processing.datatypes.StructDataType;
import org.apache.carbondata.processing.loading.DataField;
import org.apache.carbondata.processing.loading.converter.FieldConverter;
import org.apache.carbondata.processing.loading.converter.impl.ComplexFieldConverterImpl;
import org.apache.carbondata.processing.loading.converter.impl.DictionaryFieldConverterImpl;
import org.apache.carbondata.processing.loading.converter.impl.DirectDictionaryFieldConverterImpl;
import org.apache.carbondata.processing.loading.converter.impl.MeasureFieldConverterImpl;
import org.apache.carbondata.processing.loading.converter.impl.NonDictionaryFieldConverterImpl;

public class FieldEncoderFactory {
    private static FieldEncoderFactory instance;

    private FieldEncoderFactory() {
    }

    public static FieldEncoderFactory getInstance() {
        if (instance == null) {
            instance = new FieldEncoderFactory();
        }
        return instance;
    }

    public FieldConverter createFieldEncoder(DataField dataField, AbsoluteTableIdentifier absoluteTableIdentifier, int index, String nullFormat, DictionaryClient client, Boolean useOnePass, Map<Object, Integer> localCache, boolean isEmptyBadRecord, String parentTablePath, boolean isConvertToBinary) throws IOException {
        if (dataField.getColumn().isDimension().booleanValue()) {
            if (dataField.getColumn().hasEncoding(Encoding.DIRECT_DICTIONARY) && !dataField.getColumn().isComplex().booleanValue()) {
                return new DirectDictionaryFieldConverterImpl(dataField, nullFormat, index, isEmptyBadRecord);
            }
            if (dataField.getColumn().hasEncoding(Encoding.DICTIONARY) && !dataField.getColumn().isComplex().booleanValue()) {
                DictionaryColumnUniqueIdentifier identifier = null;
                if (null == dataField.getColumn().getColumnSchema().getParentColumnTableRelations() || dataField.getColumn().getColumnSchema().getParentColumnTableRelations().isEmpty()) {
                    identifier = new DictionaryColumnUniqueIdentifier(absoluteTableIdentifier, dataField.getColumn().getColumnIdentifier(), dataField.getColumn().getDataType());
                    return new DictionaryFieldConverterImpl(dataField.getColumn(), absoluteTableIdentifier.getCarbonTableIdentifier().getTableId(), nullFormat, index, client, useOnePass, localCache, isEmptyBadRecord, identifier);
                }
                ParentColumnTableRelation parentColumnTableRelation = (ParentColumnTableRelation)dataField.getColumn().getColumnSchema().getParentColumnTableRelations().get(0);
                RelationIdentifier relationIdentifier = parentColumnTableRelation.getRelationIdentifier();
                CarbonTableIdentifier parentTableIdentifier = new CarbonTableIdentifier(relationIdentifier.getDatabaseName(), relationIdentifier.getTableName(), relationIdentifier.getTableId());
                ColumnIdentifier parentColumnIdentifier = new ColumnIdentifier(parentColumnTableRelation.getColumnId(), null, dataField.getColumn().getDataType());
                AbsoluteTableIdentifier parentAbsoluteTableIdentifier = AbsoluteTableIdentifier.from((String)parentTablePath, (CarbonTableIdentifier)parentTableIdentifier);
                identifier = new DictionaryColumnUniqueIdentifier(parentAbsoluteTableIdentifier, parentColumnIdentifier, dataField.getColumn().getDataType());
                return new DictionaryFieldConverterImpl(dataField.getColumn(), parentAbsoluteTableIdentifier.getCarbonTableIdentifier().getTableId(), nullFormat, index, null, false, null, isEmptyBadRecord, identifier);
            }
            if (dataField.getColumn().isComplex().booleanValue()) {
                return new ComplexFieldConverterImpl(FieldEncoderFactory.createComplexDataType(dataField, absoluteTableIdentifier, client, useOnePass, localCache, index, nullFormat, isEmptyBadRecord), index);
            }
            if (DataTypeUtil.isPrimitiveColumn((DataType)dataField.getColumn().getDataType()) && !isConvertToBinary) {
                return new MeasureFieldConverterImpl(dataField, nullFormat, index, isEmptyBadRecord);
            }
            return new NonDictionaryFieldConverterImpl(dataField, nullFormat, index, isEmptyBadRecord);
        }
        return new MeasureFieldConverterImpl(dataField, nullFormat, index, isEmptyBadRecord);
    }

    public static GenericDataType createComplexDataType(DataField dataField, AbsoluteTableIdentifier absoluteTableIdentifier, DictionaryClient client, Boolean useOnePass, Map<Object, Integer> localCache, int index, String nullFormat, Boolean isEmptyBadRecords) {
        return FieldEncoderFactory.createComplexType(dataField.getColumn(), dataField.getColumn().getColName(), absoluteTableIdentifier, client, useOnePass, localCache, index, nullFormat, isEmptyBadRecords);
    }

    private static GenericDataType createComplexType(CarbonColumn carbonColumn, String parentName, AbsoluteTableIdentifier absoluteTableIdentifier, DictionaryClient client, Boolean useOnePass, Map<Object, Integer> localCache, int index, String nullFormat, Boolean isEmptyBadRecords) {
        DataType dataType = carbonColumn.getDataType();
        if (DataTypes.isArrayType((DataType)dataType) || DataTypes.isMapType((DataType)dataType)) {
            List listOfChildDimensions = ((CarbonDimension)carbonColumn).getListOfChildDimensions();
            ArrayDataType arrayDataType = new ArrayDataType(carbonColumn.getColName(), parentName, carbonColumn.getColumnId(), carbonColumn.hasEncoding(Encoding.DICTIONARY));
            for (CarbonDimension dimension : listOfChildDimensions) {
                arrayDataType.addChildren(FieldEncoderFactory.createComplexType((CarbonColumn)dimension, carbonColumn.getColName(), absoluteTableIdentifier, client, useOnePass, localCache, index, nullFormat, isEmptyBadRecords));
            }
            return arrayDataType;
        }
        if (DataTypes.isStructType((DataType)dataType)) {
            List dimensions = ((CarbonDimension)carbonColumn).getListOfChildDimensions();
            StructDataType structDataType = new StructDataType(carbonColumn.getColName(), parentName, carbonColumn.getColumnId(), carbonColumn.hasEncoding(Encoding.DICTIONARY));
            for (CarbonDimension dimension : dimensions) {
                structDataType.addChildren(FieldEncoderFactory.createComplexType((CarbonColumn)dimension, carbonColumn.getColName(), absoluteTableIdentifier, client, useOnePass, localCache, index, nullFormat, isEmptyBadRecords));
            }
            return structDataType;
        }
        return new PrimitiveDataType(carbonColumn, parentName, carbonColumn.getColumnId(), (CarbonDimension)carbonColumn, absoluteTableIdentifier, client, useOnePass, localCache, nullFormat, isEmptyBadRecords);
    }
}

