/*
 * Decompiled with CFR 0.152.
 */
package org.apache.carbondata.processing.loading.csvinput;

import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.apache.carbondata.common.logging.LogService;
import org.apache.carbondata.common.logging.LogServiceFactory;
import org.apache.carbondata.core.util.CarbonProperties;
import org.apache.carbondata.processing.loading.csvinput.BoundedInputStream;
import org.apache.carbondata.processing.loading.csvinput.StringArrayWritable;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang.BooleanUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.Seekable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.CodecPool;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.hadoop.io.compress.Decompressor;
import org.apache.hadoop.io.compress.SplitCompressionInputStream;
import org.apache.hadoop.io.compress.SplittableCompressionCodec;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.util.LineReader;

public class CSVInputFormat
extends FileInputFormat<NullWritable, StringArrayWritable> {
    public static final String DELIMITER = "carbon.csvinputformat.delimiter";
    public static final String DELIMITER_DEFAULT = ",";
    public static final String COMMENT = "carbon.csvinputformat.comment";
    public static final String COMMENT_DEFAULT = "#";
    public static final String QUOTE = "carbon.csvinputformat.quote";
    public static final String QUOTE_DEFAULT = "\"";
    public static final String ESCAPE = "carbon.csvinputformat.escape";
    public static final String ESCAPE_DEFAULT = "\\";
    public static final String HEADER_PRESENT = "carbon.csvinputformat.header.present";
    public static final boolean HEADER_PRESENT_DEFAULT = false;
    public static final String SKIP_EMPTY_LINE = "carbon.csvinputformat.skip.empty.line";
    public static final String READ_BUFFER_SIZE = "carbon.csvinputformat.read.buffer.size";
    public static final String READ_BUFFER_SIZE_DEFAULT = "65536";
    public static final String MAX_COLUMNS = "carbon.csvinputformat.max.columns";
    public static final String NUMBER_OF_COLUMNS = "carbon.csvinputformat.number.of.columns";
    public static final int DEFAULT_MAX_NUMBER_OF_COLUMNS_FOR_PARSING = 2000;
    public static final int THRESHOLD_MAX_NUMBER_OF_COLUMNS_FOR_PARSING = 20000;
    private static LogService LOGGER = LogServiceFactory.getLogService((String)CSVInputFormat.class.toString());

    public RecordReader<NullWritable, StringArrayWritable> createRecordReader(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        return new CSVRecordReader();
    }

    protected boolean isSplitable(JobContext context, Path file) {
        CompressionCodec codec = new CompressionCodecFactory(context.getConfiguration()).getCodec(file);
        if (null == codec) {
            return true;
        }
        return codec instanceof SplittableCompressionCodec;
    }

    public static void setCommentCharacter(Configuration configuration, String commentChar) {
        if (commentChar != null && !commentChar.isEmpty()) {
            configuration.set(COMMENT, commentChar);
        }
    }

    public static void setCSVDelimiter(Configuration configuration, String delimiter) {
        if (delimiter != null && !delimiter.isEmpty()) {
            configuration.set(DELIMITER, delimiter);
        }
    }

    public static void setSkipEmptyLine(Configuration configuration, String skipEmptyLine) {
        if (skipEmptyLine != null && !skipEmptyLine.isEmpty()) {
            configuration.set(SKIP_EMPTY_LINE, skipEmptyLine);
        } else {
            try {
                BooleanUtils.toBoolean((String)CarbonProperties.getInstance().getProperty("carbon.skip.empty.line"), (String)"true", (String)"false");
                configuration.set(SKIP_EMPTY_LINE, CarbonProperties.getInstance().getProperty("carbon.skip.empty.line"));
            }
            catch (Exception e) {
                configuration.set(SKIP_EMPTY_LINE, "false");
            }
        }
    }

    public static void setEscapeCharacter(Configuration configuration, String escapeCharacter) {
        if (escapeCharacter != null && !escapeCharacter.isEmpty()) {
            configuration.set(ESCAPE, escapeCharacter);
        }
    }

    public static void setHeaderExtractionEnabled(Configuration configuration, boolean headerExtractEnable) {
        configuration.set(HEADER_PRESENT, String.valueOf(headerExtractEnable));
    }

    public static void setQuoteCharacter(Configuration configuration, String quoteCharacter) {
        if (quoteCharacter != null && !quoteCharacter.isEmpty()) {
            configuration.set(QUOTE, quoteCharacter);
        }
    }

    public static void setReadBufferSize(Configuration configuration, String bufferSize) {
        if (bufferSize != null && !bufferSize.isEmpty()) {
            configuration.set(READ_BUFFER_SIZE, bufferSize);
        }
    }

    public static void setMaxColumns(Configuration configuration, String maxColumns) {
        if (maxColumns != null) {
            configuration.set(MAX_COLUMNS, maxColumns);
        }
    }

    public static void setNumberOfColumns(Configuration configuration, String numberOfColumns) {
        configuration.set(NUMBER_OF_COLUMNS, numberOfColumns);
    }

    public static CsvParserSettings extractCsvParserSettings(Configuration job) {
        CsvParserSettings parserSettings = new CsvParserSettings();
        ((CsvFormat)parserSettings.getFormat()).setDelimiter(job.get(DELIMITER, DELIMITER_DEFAULT).charAt(0));
        ((CsvFormat)parserSettings.getFormat()).setComment(job.get(COMMENT, COMMENT_DEFAULT).charAt(0));
        parserSettings.setLineSeparatorDetectionEnabled(true);
        parserSettings.setNullValue("");
        parserSettings.setEmptyValue("");
        parserSettings.setIgnoreLeadingWhitespaces(false);
        parserSettings.setIgnoreTrailingWhitespaces(false);
        parserSettings.setSkipEmptyLines(Boolean.valueOf(job.get(SKIP_EMPTY_LINE, "false")).booleanValue());
        parserSettings.setMaxCharsPerColumn(-1);
        String maxColumns = job.get(MAX_COLUMNS, "2000");
        parserSettings.setMaxColumns(Integer.parseInt(maxColumns));
        ((CsvFormat)parserSettings.getFormat()).setQuote(job.get(QUOTE, QUOTE_DEFAULT).charAt(0));
        ((CsvFormat)parserSettings.getFormat()).setQuoteEscape(job.get(ESCAPE, ESCAPE_DEFAULT).charAt(0));
        parserSettings.setErrorContentLength(0);
        return parserSettings;
    }

    public static class CSVRecordReader
    extends RecordReader<NullWritable, StringArrayWritable> {
        private long start;
        private long end;
        private BoundedInputStream boundedInputStream;
        private Reader reader;
        private CsvParser csvParser;
        private StringArrayWritable value;
        private String[] columns;
        private Seekable filePosition;
        private boolean isCompressedInput;
        private Decompressor decompressor;

        public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
            Object inputStream;
            FileSplit split = (FileSplit)inputSplit;
            this.start = split.getStart();
            this.end = this.start + split.getLength();
            Path file = split.getPath();
            Configuration job = context.getConfiguration();
            CompressionCodec codec = new CompressionCodecFactory(job).getCodec(file);
            FileSystem fs = file.getFileSystem(job);
            int bufferSize = Integer.parseInt(job.get(CSVInputFormat.READ_BUFFER_SIZE, CSVInputFormat.READ_BUFFER_SIZE_DEFAULT));
            FSDataInputStream fileIn = fs.open(file, bufferSize);
            if (codec != null) {
                this.isCompressedInput = true;
                this.decompressor = CodecPool.getDecompressor((CompressionCodec)codec);
                if (codec instanceof SplittableCompressionCodec) {
                    SplitCompressionInputStream scIn = ((SplittableCompressionCodec)codec).createInputStream((InputStream)fileIn, this.decompressor, this.start, this.end, SplittableCompressionCodec.READ_MODE.BYBLOCK);
                    this.start = scIn.getAdjustedStart();
                    this.end = scIn.getAdjustedEnd();
                    if (this.start != 0L) {
                        LineReader lineReader = new LineReader((InputStream)scIn, 1);
                        this.start += (long)lineReader.readLine(new Text(), 0);
                    }
                    this.filePosition = scIn;
                    inputStream = scIn;
                } else {
                    CompressionInputStream cIn = codec.createInputStream((InputStream)fileIn, this.decompressor);
                    this.filePosition = cIn;
                    inputStream = cIn;
                }
            } else {
                fileIn.seek(this.start);
                if (this.start != 0L) {
                    LineReader lineReader = new LineReader((InputStream)fileIn, 1);
                    this.start += (long)lineReader.readLine(new Text(), 0);
                }
                this.boundedInputStream = new BoundedInputStream((DataInputStream)fileIn, this.end - this.start);
                this.filePosition = fileIn;
                inputStream = this.boundedInputStream;
            }
            this.reader = new InputStreamReader((InputStream)new BOMInputStream((InputStream)inputStream), Charset.forName("UTF-8"));
            CsvParserSettings settings = CSVInputFormat.extractCsvParserSettings(job);
            if (this.start == 0L) {
                settings.setHeaderExtractionEnabled(job.getBoolean(CSVInputFormat.HEADER_PRESENT, false));
            }
            this.csvParser = new CsvParser(settings);
            this.csvParser.beginParsing(this.reader);
        }

        public boolean nextKeyValue() throws IOException, InterruptedException {
            if (this.csvParser == null) {
                return false;
            }
            this.columns = this.csvParser.parseNext();
            if (this.columns == null) {
                this.value = null;
                return false;
            }
            if (this.value == null) {
                this.value = new StringArrayWritable();
            }
            this.value.set(this.columns);
            return true;
        }

        public NullWritable getCurrentKey() throws IOException, InterruptedException {
            return NullWritable.get();
        }

        public StringArrayWritable getCurrentValue() throws IOException, InterruptedException {
            return this.value;
        }

        private long getPos() throws IOException {
            long retVal = this.start;
            if (null != this.boundedInputStream) {
                retVal = this.end - this.boundedInputStream.getRemaining();
            } else if (this.isCompressedInput && null != this.filePosition) {
                retVal = this.filePosition.getPos();
            }
            return retVal;
        }

        public float getProgress() throws IOException, InterruptedException {
            return this.start == this.end ? 0.0f : Math.min(1.0f, (float)(this.getPos() - this.start) / (float)(this.end - this.start));
        }

        public void close() throws IOException {
            try {
                if (this.reader != null) {
                    this.reader.close();
                }
                if (this.boundedInputStream != null) {
                    this.boundedInputStream.close();
                }
                if (null != this.csvParser) {
                    this.csvParser.stopParsing();
                }
            }
            finally {
                this.reader = null;
                this.boundedInputStream = null;
                this.csvParser = null;
                this.filePosition = null;
                this.value = null;
                if (this.decompressor != null) {
                    CodecPool.returnDecompressor((Decompressor)this.decompressor);
                    this.decompressor = null;
                }
            }
        }
    }
}

